/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.open.controller;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.annotation.SystemLog;
import plus.hiver.common.api.Result;
import plus.hiver.common.entity.User;
import plus.hiver.common.enums.LogType;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.service.UserService;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.module.open.entity.Client;
import plus.hiver.module.open.service.ClientService;
import plus.hiver.module.open.vo.Oauth2TokenInfo;

@RestController
@Tag(name="OAuth2\u8ba4\u8bc1\u63a5\u53e3")
@PermissionTag(permission="oauth2:*")
@RequestMapping(value={"/hiver/oauth2"})
public class Oauth2Controller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Oauth2Controller.class);
    @Resource
    private ClientService clientService;
    @Resource
    private UserService userService;
    @Resource
    private SecurityUtil securityUtil;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @GetMapping(value={"/info/{client_id}"})
    @Operation(summary="\u7ad9\u70b9\u57fa\u672c\u4fe1\u606f")
    public Result info(@Parameter(description="\u5ba2\u6237\u7aefid") @PathVariable Long l) {
        Client client = this.getClient(l);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
        hashMap.put("name", client.getName());
        hashMap.put("homeUri", client.getHomeUri());
        hashMap.put("logo", client.getLogo());
        hashMap.put("autoApprove", client.getAutoApprove());
        return ResultUtil.data(hashMap);
    }

    @PostMapping(value={"/authorize"})
    @Operation(summary="\u8ba4\u8bc1\u83b7\u53d6code")
    @SystemLog(description="\u8ba4\u8bc1\u4e2d\u5fc3\u767b\u5f55", type=LogType.LOGIN)
    public Result authorize(@Parameter(description="\u7528\u6237\u540d") @RequestParam String string, @Parameter(description="\u5bc6\u7801") @RequestParam String string2, @Parameter(description="\u5ba2\u6237\u7aefid") @RequestParam Long l, @Parameter(description="\u6210\u529f\u6388\u6743\u540e\u56de\u8c03\u5730\u5740") @RequestParam String string3, @Parameter(description="\u6388\u6743\u7c7b\u578b\u4e3acode") @RequestParam(required=false, defaultValue="code") String string4, @Parameter(description="\u5ba2\u6237\u7aef\u72b6\u6001\u503c") @RequestParam String string5) {
        Client client = this.getClient(l);
        if (!client.getRedirectUri().equals(string3)) {
            return ResultUtil.error((String)"\u56de\u8c03\u5730\u5740redirect_uri\u4e0d\u6b63\u786e");
        }
        User user = this.securityUtil.checkUserPassword(string, string2);
        if (user == null) {
            return ResultUtil.error((String)"\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        String string6 = this.securityUtil.getToken(user, Boolean.valueOf(true));
        String string7 = IdUtil.simpleUUID();
        this.redisTemplateHelper.set("OAUTH_CODE:" + string7, new Gson().toJson((Object)new Oauth2TokenInfo(l, user.getUsername())), 5L, TimeUnit.MINUTES);
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        hashMap.put("code", string7);
        hashMap.put("redirect_uri", string3);
        hashMap.put("state", string5);
        hashMap.put("accessToken", string6);
        return ResultUtil.data(hashMap);
    }

    @GetMapping(value={"/token"})
    @Operation(summary="\u83b7\u53d6access_token\u4ee4\u724c")
    public Result token(@Parameter(description="\u6388\u6743\u7c7b\u578b") @RequestParam String string, @Parameter(description="\u5ba2\u6237\u7aefid") @RequestParam Long l, @Parameter(description="\u5ba2\u6237\u7aef\u79d8\u94a5") @RequestParam String string2, @Parameter(description="\u8ba4\u8bc1\u8fd4\u56de\u7684code") @RequestParam(required=false) String string3, @Parameter(description="\u5237\u65b0token") @RequestParam(required=false) String string4, @Parameter(description="\u6210\u529f\u6388\u6743\u540e\u56de\u8c03\u5730\u5740") @RequestParam(required=false) String string5) {
        Object object;
        Object object2;
        Client client = this.getClient(l);
        if (!client.getClientSecret().equals(string2)) {
            return ResultUtil.error((String)"client_secret\u4e0d\u6b63\u786e");
        }
        Oauth2TokenInfo oauth2TokenInfo = null;
        if ("authorization_code".equals(string)) {
            if (!client.getRedirectUri().equals(string5)) {
                return ResultUtil.error((String)"\u56de\u8c03\u5730\u5740redirect_uri\u4e0d\u6b63\u786e");
            }
            object2 = this.redisTemplateHelper.get("OAUTH_CODE:" + string3);
            if (StrUtil.isBlank((CharSequence)object2)) {
                return ResultUtil.error((String)"code\u5df2\u8fc7\u671f");
            }
            oauth2TokenInfo = (Oauth2TokenInfo)new Gson().fromJson((String)object2, Oauth2TokenInfo.class);
            if (!oauth2TokenInfo.getClientId().equals(l)) {
                return ResultUtil.error((String)"code\u4e0d\u6b63\u786e");
            }
        } else if ("refresh_token".equals(string)) {
            object2 = this.redisTemplateHelper.get("OAUTH_TOKEN_INFO:" + string4);
            if (StrUtil.isBlank((CharSequence)object2)) {
                return ResultUtil.error((String)"refresh_token\u5df2\u8fc7\u671f");
            }
            oauth2TokenInfo = (Oauth2TokenInfo)new Gson().fromJson((String)object2, Oauth2TokenInfo.class);
            if (!oauth2TokenInfo.getClientId().equals(l)) {
                return ResultUtil.error((String)"refresh_token\u4e0d\u6b63\u786e");
            }
        } else {
            return ResultUtil.error((String)"\u6388\u6743\u7c7b\u578bgrant_type\u4e0d\u6b63\u786e");
        }
        object2 = null;
        String string6 = null;
        Long l2 = null;
        String string7 = "OAUTH_TOKEN:" + oauth2TokenInfo.getUsername() + ":" + l;
        String string8 = "OAUTH_REFRESH_TOKEN:" + oauth2TokenInfo.getUsername() + ":" + l;
        if ("authorization_code".equals(string)) {
            object = this.redisTemplateHelper.get(string7);
            String string9 = this.redisTemplateHelper.get(string8);
            if (StrUtil.isNotBlank((CharSequence)object) && StrUtil.isNotBlank((CharSequence)string9)) {
                object2 = object;
                string6 = string9;
                l2 = this.redisTemplateHelper.getExpire("OAUTH_TOKEN_INFO:" + (String)object2, TimeUnit.SECONDS);
            } else {
                String string10 = IdUtil.simpleUUID();
                String string11 = IdUtil.simpleUUID();
                this.redisTemplateHelper.set(string7, string10, 30L, TimeUnit.DAYS);
                this.redisTemplateHelper.set(string8, string11, 30L, TimeUnit.DAYS);
                this.redisTemplateHelper.set("OAUTH_TOKEN_INFO:" + string10, new Gson().toJson((Object)oauth2TokenInfo), 30L, TimeUnit.DAYS);
                this.redisTemplateHelper.set("OAUTH_TOKEN_INFO:" + string11, new Gson().toJson((Object)oauth2TokenInfo), 30L, TimeUnit.DAYS);
                object2 = string10;
                string6 = string11;
                l2 = this.redisTemplateHelper.getExpire("OAUTH_TOKEN_INFO:" + (String)object2, TimeUnit.SECONDS);
            }
        } else if ("refresh_token".equals(string)) {
            object = IdUtil.simpleUUID();
            String string12 = IdUtil.simpleUUID();
            this.redisTemplateHelper.set(string7, (String)object, 30L, TimeUnit.DAYS);
            this.redisTemplateHelper.set(string8, string12, 30L, TimeUnit.DAYS);
            this.redisTemplateHelper.set("OAUTH_TOKEN_INFO:" + (String)object, new Gson().toJson((Object)oauth2TokenInfo), 30L, TimeUnit.DAYS);
            this.redisTemplateHelper.set("OAUTH_TOKEN_INFO:" + string12, new Gson().toJson((Object)oauth2TokenInfo), 30L, TimeUnit.DAYS);
            object2 = object;
            string6 = string12;
            l2 = this.redisTemplateHelper.getExpire("OAUTH_TOKEN_INFO:" + (String)object2, TimeUnit.SECONDS);
            this.redisTemplateHelper.delete("OAUTH_TOKEN_INFO:" + string4);
        }
        object = new HashMap(16);
        object.put("access_token", object2);
        object.put("expires_in", l2);
        object.put("refresh_token", string6);
        return ResultUtil.data((Object)object);
    }

    @PostMapping(value={"/authorized"})
    @Operation(summary="\u5df2\u8ba4\u8bc1\u8fc7\u83b7\u53d6code/\u5355\u70b9\u767b\u5f55\u5b9e\u73b0")
    public Result authorized(@Parameter(description="\u5ba2\u6237\u7aefid") @RequestParam Long l, @Parameter(description="\u6210\u529f\u6388\u6743\u540e\u56de\u8c03\u5730\u5740") @RequestParam String string, @Parameter(description="\u5ba2\u6237\u7aef\u72b6\u6001\u503c") @RequestParam String string2) {
        Client client = this.getClient(l);
        if (!client.getRedirectUri().equals(string)) {
            return ResultUtil.error((String)"\u56de\u8c03\u5730\u5740redirect_uri\u4e0d\u6b63\u786e");
        }
        User user = this.securityUtil.getCurrUserSimple();
        String string3 = IdUtil.simpleUUID();
        this.redisTemplateHelper.set("OAUTH_CODE:" + string3, new Gson().toJson((Object)new Oauth2TokenInfo(l, user.getUsername())), 5L, TimeUnit.MINUTES);
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        hashMap.put("code", string3);
        hashMap.put("redirect_uri", string);
        hashMap.put("state", string2);
        return ResultUtil.data(hashMap);
    }

    @PostMapping(value={"/logout"})
    @Operation(summary="\u9000\u51fa\u767b\u5f55\uff08\u5185\u90e8\u4fe1\u4efb\u7ad9\u70b9\u4f7f\u7528\uff09")
    public Result logout() {
        User user = this.securityUtil.getCurrUserSimple();
        String string = this.redisTemplateHelper.get("HIVER_USER_TOKEN:" + user.getUsername());
        this.redisTemplateHelper.delete(string);
        this.redisTemplateHelper.delete("HIVER_USER_TOKEN:" + user.getUsername());
        this.redisTemplateHelper.deleteByPattern("OAUTH_TOKEN:" + user.getUsername() + ":*");
        this.redisTemplateHelper.deleteByPattern("OAUTH_REFRESH_TOKEN:" + user.getUsername() + ":*");
        return ResultUtil.data(null);
    }

    @GetMapping(value={"/user"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public Result user(@Parameter(description="\u4ee4\u724c") @RequestParam String string) {
        String string2 = this.redisTemplateHelper.get("OAUTH_TOKEN_INFO:" + string);
        if (StrUtil.isBlank((CharSequence)string2)) {
            return ResultUtil.error((String)"access_token\u5df2\u8fc7\u671f\u5931\u6548");
        }
        Oauth2TokenInfo oauth2TokenInfo = (Oauth2TokenInfo)new Gson().fromJson(string2, Oauth2TokenInfo.class);
        User user = this.userService.findByUsername(oauth2TokenInfo.getUsername());
        if (user == null) {
            return ResultUtil.error((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        hashMap.put("username", oauth2TokenInfo.getUsername());
        hashMap.put("avatar", user.getAvatar());
        hashMap.put("sex", user.getSex());
        return ResultUtil.data(hashMap);
    }

    private Client getClient(Long l) {
        Client client = (Client)this.clientService.findById(l);
        if (client == null) {
            throw new HiverException("\u5ba2\u6237\u7aefclient_id\u4e0d\u5b58\u5728");
        }
        return client;
    }

    @Generated
    public Oauth2Controller(ClientService clientService, UserService userService, SecurityUtil securityUtil, RedisTemplateHelper redisTemplateHelper) {
        this.clientService = clientService;
        this.userService = userService;
        this.securityUtil = securityUtil;
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

