/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.open.serviceimpl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Nullable;
import jakarta.annotation.Resource;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.open.dao.ClientDao;
import plus.hiver.module.open.entity.Client;
import plus.hiver.module.open.service.ClientService;

@Service
@Transactional
@CacheConfig(cacheNames={"client"})
public class ClientServiceImpl
extends HiverBaseServiceImpl<Client, Long, ClientDao>
implements ClientService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientServiceImpl.class);
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    protected ClientServiceImpl(ClientDao clientDao) {
        super((HiverBaseDao)clientDao);
    }

    @Cacheable(key="#id")
    public Client get(Long l) {
        String string = this.redisTemplateHelper.get("client::" + l);
        if ("null".equals(string)) {
            return null;
        }
        Client client = ((ClientDao)this.dao).findById(l).orElse(null);
        if (client == null) {
            this.redisTemplateHelper.set("client::" + l, "null", 5L, TimeUnit.MINUTES);
        }
        return client;
    }

    @CacheEvict(key="#client.id")
    public Client update(Client client) {
        return (Client)((Object)((ClientDao)this.dao).saveAndFlush((Object)client));
    }

    @CacheEvict(key="#id")
    public void delete(Long l) {
        ((ClientDao)this.dao).deleteById(l);
    }

    @Override
    public Page<Client> findByCondition(final Client client, final SearchVo searchVo, Pageable pageable) {
        return ((ClientDao)this.dao).findAll((Specification)new Specification<Client>(){

            @Nullable
            public Predicate toPredicate(Root<Client> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                DateTime dateTime;
                Path path = root.get("name");
                Path path2 = root.get("homeUri");
                Path path3 = root.get("createTime");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)client.getName())) {
                    arrayList.add(criteriaBuilder.like((Expression)path, "%" + client.getName() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)client.getHomeUri())) {
                    arrayList.add(criteriaBuilder.like((Expression)path2, "%" + client.getHomeUri() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
                    dateTime = DateUtil.parse((CharSequence)searchVo.getStartDate());
                    DateTime dateTime2 = DateUtil.parse((CharSequence)searchVo.getEndDate());
                    arrayList.add(criteriaBuilder.between((Expression)path3, (Comparable)dateTime, (Comparable)DateUtil.endOfDay((Date)dateTime2)));
                }
                dateTime = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray((T[])dateTime));
                return null;
            }
        }, pageable);
    }
}

