/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.open.controller;

import cn.hutool.core.util.IdUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseController;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.open.entity.Client;
import plus.hiver.module.open.service.ClientService;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@RestController
@AllArgsConstructor
@Tag(name = "客户端管理接口")
@PermissionTag(permission = "client:*" )
@RequestMapping("/hiver/client")
@Transactional
public class ClientController extends HiverBaseController<Client, Long> {
    @Resource
    private ClientService clientService;

    @Override
    public HiverBaseService getService() {
        return clientService;
    }

    @GetMapping(value = "/getByCondition")
    @Operation(summary = "多条件分页获取")
    public Result<Page<Client>> getByCondition(Client client, SearchVo searchVo, PageVo pageVo) {
        Page<Client> page = clientService.findByCondition(client, searchVo, PageUtil.initPage(pageVo));
        return new ResultUtil<Page<Client>>().setData(page);
    }

    @GetMapping(value = "/getSecretKey")
    @Operation(summary = "生成随机secretKey")
    public Result<String> getSecretKey() {
        String secretKey = IdUtil.simpleUUID();
        return new ResultUtil<String>().setData(secretKey);
    }
}
