/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.open.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_client")
@TableName("t_client")
@Tag(name = "第三方网站client信息")
public class Client extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @Schema(description = "网站名称")
    private String name;

    @Schema(description = "网站Logo")
    private String logo;

    @Schema(description = "网站主页")
    private String homeUri;

    @Schema(description = "秘钥")
    private String clientSecret;

    @Schema(description = "成功授权后的回调地址")
    private String redirectUri;

    @Schema(description = "自动授权 默认false")
    private Boolean autoApprove = false;
}
