/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.open.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.open.entity.Client;

/**
 * 客户端接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface ClientService extends HiverBaseService<Client, Long> {
    /**
     * 多条件分页获取
     *
     * @param client
     * @param searchVo
     * @param pageable
     * @return
     */
    Page<Client> findByCondition(Client client, SearchVo searchVo, Pageable pageable);
}
