/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.quartz.aop;

import cn.hutool.core.thread.threadlocal.NamedThreadLocal;
import jakarta.annotation.Resource;
import java.util.Date;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import plus.hiver.common.utils.ThreadPoolUtil;
import plus.hiver.module.quartz.entity.QuartzJob;
import plus.hiver.module.quartz.entity.QuartzLog;
import plus.hiver.module.quartz.service.QuartzJobService;
import plus.hiver.module.quartz.service.QuartzLogService;

@Aspect
@Component
public class QuartzLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzLogAspect.class);
    private static final ThreadLocal<Date> THREAD_LOCAL_BEGIN_TIME = new NamedThreadLocal("ThreadLocal beginTime");
    @Resource
    private QuartzJobService jobService;
    @Resource
    private QuartzLogService logService;

    @Pointcut(value="@annotation(plus.hiver.module.quartz.annotation.QuartzRecordLog)")
    public void quartzLogAspect() {
    }

    @Before(value="quartzLogAspect()")
    public void doBefore(JoinPoint joinPoint) {
        Date date = new Date();
        THREAD_LOCAL_BEGIN_TIME.set(date);
    }

    @AfterReturning(value="quartzLogAspect()")
    public void after(JoinPoint joinPoint) {
        try {
            QuartzLog quartzLog = new QuartzLog();
            String string = joinPoint.getTarget().getClass().getName();
            QuartzJob quartzJob = this.jobService.findByJobClassName(string);
            if (quartzJob == null || !quartzJob.getIsRecordLog().booleanValue()) {
                return;
            }
            quartzLog.setJobClassName(string);
            quartzLog.setExecuteTime(new Date());
            long l = THREAD_LOCAL_BEGIN_TIME.get().getTime();
            long l2 = System.currentTimeMillis();
            Long l3 = l2 - l;
            quartzLog.setCostTime(l3.intValue());
            ThreadPoolUtil.getPool().execute(new SaveQuartzLogThread(quartzLog, this.logService));
        }
        catch (Exception exception) {
            log.error("AOP\u540e\u7f6e\u901a\u77e5\u5f02\u5e38", (Throwable)exception);
        }
        THREAD_LOCAL_BEGIN_TIME.remove();
    }

    private static class SaveQuartzLogThread
    implements Runnable {
        private final QuartzLog log;
        private final QuartzLogService logService;

        public SaveQuartzLogThread(QuartzLog quartzLog, QuartzLogService quartzLogService) {
            this.log = quartzLog;
            this.logService = quartzLogService;
        }

        @Override
        public void run() {
            this.logService.save(this.log);
        }
    }
}

