/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.quartz.dao;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.module.quartz.entity.QuartzLog;

/**
 * 定时任务执行日志数据处理层
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Repository
public interface QuartzLogDao extends HiverBaseDao<QuartzLog, Long> {
    /**
     * 通过className删除
     *
     * @param jobClassName
     */
    @Modifying
    @Query("delete from QuartzLog m where m.jobClassName = ?1")
    void deleteByJobClassName(String jobClassName);
}
