/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.quartz.jobs;

import cn.hutool.core.date.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import plus.hiver.module.quartz.annotation.QuartzRecordLog;

/**
 * 示例带参定时任务
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
public class SampleParamJob implements Job {
    /**
     * 若参数变量名修改 QuartzJobController中也需对应修改
     */
    private String parameter;

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    @Override
    @QuartzRecordLog
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info(String.format("Hello %s! 欢迎使用Hiver前后端分离开发平台!时间:" + DateUtil.now(), this.parameter));
    }
}
