/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.quartz.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.module.quartz.entity.QuartzJob;

/**
 * 定时任务接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface QuartzJobService extends HiverBaseService<QuartzJob, Long> {
    /**
     * 通过类名获取
     *
     * @param jobClassName
     * @return
     */
    QuartzJob findByJobClassName(String jobClassName);

    /**
     * 分页获取
     *
     * @param key
     * @param pageable
     * @return
     */
    Page<QuartzJob> findByCondition(String key, Pageable pageable);
}
