/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.quartz.serviceimpl;

import cn.hutool.core.util.StrUtil;
import jakarta.persistence.criteria.*;
import jakarta.transaction.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.quartz.dao.QuartzLogDao;
import plus.hiver.module.quartz.entity.QuartzLog;
import plus.hiver.module.quartz.service.QuartzLogService;

import java.util.ArrayList;
import java.util.List;

/**
 * 定时任务执行日志接口实现
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@Service
@Transactional
public class QuartzLogServiceImpl extends HiverBaseServiceImpl<QuartzLog, Long, QuartzLogDao> implements QuartzLogService {
    public QuartzLogServiceImpl(QuartzLogDao dao) {
        super(dao);
    }

    @Override
    public Page<QuartzLog> findByCondition(QuartzLog quartzLog, SearchVo searchVo, Pageable pageable) {
        return dao.findAll(new Specification<QuartzLog>() {
            @Nullable
            @Override
            public Predicate toPredicate(Root<QuartzLog> root, CriteriaQuery<?> cq, CriteriaBuilder cb) {
                Path<String> jobClassNameField = root.get("jobClassName");

                List<Predicate> list = new ArrayList<>();

                // 任务类名相等匹配
                if (StrUtil.isNotBlank(quartzLog.getJobClassName())) {
                    list.add(cb.equal(jobClassNameField, quartzLog.getJobClassName()));
                }

                Predicate[] arr = new Predicate[list.size()];
                cq.where(list.toArray(arr));
                return null;
            }
        }, pageable);
    }

    @Override
    public void deleteByJobClassName(String jobClassName) {
        dao.deleteByJobClassName(jobClassName);
    }
}
