/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.quartz.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SnowFlakeUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.module.quartz.entity.QuartzJob;
import plus.hiver.module.quartz.service.QuartzJobService;
import plus.hiver.module.quartz.service.QuartzLogService;
import plus.hiver.module.quartz.utils.SchedulerUtil;

@RestController
@Tag(name="\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65e5\u5fd7\u7ba1\u7406\u63a5\u53e3")
@RequestMapping(value={"/hiver/quartzJob"})
@PermissionTag(permission="quartzJob:*")
@Transactional
public class QuartzJobController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzJobController.class);
    @Resource
    private QuartzJobService quartzJobService;
    @Resource
    private QuartzLogService quartzLogService;
    @Resource
    private SchedulerUtil schedulerUtil;

    @GetMapping(value={"/getAllByPage"})
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u5b9a\u65f6\u4efb\u52a1")
    public Result<Page<QuartzJob>> getAllByPage(String string, PageVo pageVo) {
        Page<QuartzJob> page = this.quartzJobService.findByCondition(string, PageUtil.initPage((PageVo)pageVo));
        return new ResultUtil().setData(page);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1")
    public Result addJob(@RequestBody QuartzJob quartzJob) {
        quartzJob.setId(SnowFlakeUtil.nextId());
        QuartzJob quartzJob2 = this.quartzJobService.findByJobClassName(quartzJob.getJobClassName());
        if (quartzJob2 != null) {
            return ResultUtil.error((String)"\u8be5\u5b9a\u65f6\u4efb\u52a1\u7c7b\u540d\u5df2\u5b58\u5728");
        }
        this.schedulerUtil.add(quartzJob);
        this.quartzJobService.save(quartzJob);
        return ResultUtil.success((String)"\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1")
    public Result editJob(@RequestBody QuartzJob quartzJob) {
        this.schedulerUtil.delete(quartzJob);
        this.schedulerUtil.add(quartzJob);
        quartzJob.setStatus(HiverConstant.STATUS_NORMAL);
        this.quartzJobService.update(quartzJob);
        return ResultUtil.success((String)"\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    @PostMapping(value={"/pause"})
    @Operation(summary="\u6682\u505c\u5b9a\u65f6\u4efb\u52a1")
    public Result pauseJob(QuartzJob quartzJob) {
        this.schedulerUtil.pauseJob(quartzJob);
        quartzJob.setStatus(HiverConstant.STATUS_DISABLE);
        this.quartzJobService.update(quartzJob);
        return ResultUtil.success((String)"\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    @PostMapping(value={"/resume"})
    @Operation(summary="\u6062\u590d\u5b9a\u65f6\u4efb\u52a1")
    public Result resumeJob(QuartzJob quartzJob) {
        this.schedulerUtil.resumeJob(quartzJob);
        quartzJob.setStatus(HiverConstant.STATUS_NORMAL);
        this.quartzJobService.update(quartzJob);
        return ResultUtil.success((String)"\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    @PostMapping(value={"/changeRecordLog"})
    @Operation(summary="\u6539\u53d8\u8bb0\u5f55\u65e5\u5fd7\u5f00\u5173")
    public Result changeRecordLog(Long l) {
        QuartzJob quartzJob;
        quartzJob.setIsRecordLog((quartzJob = (QuartzJob)this.quartzJobService.get(l)).getIsRecordLog() == false);
        this.quartzJobService.update(quartzJob);
        return ResultUtil.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/delByIds"})
    @Operation(summary="\u5220\u9664\u5b9a\u65f6\u4efb\u52a1")
    public Result deleteJob(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            QuartzJob quartzJob = (QuartzJob)this.quartzJobService.get(l);
            this.schedulerUtil.delete(quartzJob);
            this.quartzJobService.delete(quartzJob);
            this.quartzLogService.deleteByJobClassName(quartzJob.getJobClassName());
        }
        return ResultUtil.success((String)"\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }
}

