/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.quartz.serviceimpl;

import cn.hutool.core.util.StrUtil;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.quartz.dao.QuartzLogDao;
import plus.hiver.module.quartz.entity.QuartzLog;
import plus.hiver.module.quartz.service.QuartzLogService;

@Service
@Transactional
public class QuartzLogServiceImpl
extends HiverBaseServiceImpl<QuartzLog, Long, QuartzLogDao>
implements QuartzLogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzLogServiceImpl.class);

    public QuartzLogServiceImpl(QuartzLogDao quartzLogDao) {
        super((HiverBaseDao)quartzLogDao);
    }

    @Override
    public Page<QuartzLog> findByCondition(final QuartzLog quartzLog, SearchVo searchVo, Pageable pageable) {
        return ((QuartzLogDao)this.dao).findAll((Specification)new Specification<QuartzLog>(){

            @Nullable
            public Predicate toPredicate(Root<QuartzLog> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                Path path = root.get("jobClassName");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)quartzLog.getJobClassName())) {
                    arrayList.add(criteriaBuilder.equal((Expression)path, (Object)quartzLog.getJobClassName()));
                }
                Predicate[] predicateArray = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray(predicateArray));
                return null;
            }
        }, pageable);
    }

    @Override
    public void deleteByJobClassName(String string) {
        ((QuartzLogDao)this.dao).deleteByJobClassName(string);
    }
}

