/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.quartz.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.quartz.entity.QuartzLog;
import plus.hiver.module.quartz.service.QuartzLogService;

import java.util.Arrays;

/**
 * 定时任务执行日志管理接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@RestController
@Tag(name = "定时任务执行日志管理接口")
@AllArgsConstructor
@RequestMapping("/hiver/quartzLog")
@PermissionTag(permission = "quartzLog:*" )
@Transactional
public class QuartzLogController {
    @Resource
    private QuartzLogService quartzLogService;

    @GetMapping(value = "/getByCondition")
    @Operation(summary = "多条件分页获取")
    public Result<Page<QuartzLog>> getByCondition(QuartzLog quartzLog, SearchVo searchVo, PageVo pageVo) {
        Page<QuartzLog> page = quartzLogService.findByCondition(quartzLog, searchVo, PageUtil.initPage(pageVo));
        return new ResultUtil<Page<QuartzLog>>().setData(page);
    }

    @PostMapping(value = "/delByIds")
    @Operation(summary = "删除日志")
    public Result delByIds(@RequestParam Long[] ids) {
        quartzLogService.deleteAllById(Arrays.asList(ids));
        return ResultUtil.success("删除定时任务成功");
    }
}
