/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.quartz.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.HiverConstant;

/**
 * 任务实体类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Accessors(chain = true)
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "t_quartz_job")
@TableName("t_quartz_job")
@Tag(name = "定时任务")
public class QuartzJob  extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @Schema(description = "任务名")
    private String title;

    @Schema(description = "任务类名")
    private String jobClassName;

    @Schema(description = "cron表达式")
    private String cronExpression;

    @Schema(description = "失效执行策略")
    private Integer misfirePolicy;

    @Schema(description = "是否记录执行日志")
    private Boolean isRecordLog;

    @Schema(description = "参数")
    private String parameter;

    @Schema(description = "状态 0正常 -1停止")
    private Integer status = HiverConstant.STATUS_NORMAL;
}
