/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.quartz.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.quartz.entity.QuartzLog;

/**
 * 定时任务执行日志接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface QuartzLogService extends HiverBaseService<QuartzLog, Long> {
    /**
     * 多条件分页获取
     *
     * @param quartzLog
     * @param searchVo
     * @param pageable
     * @return
     */
    Page<QuartzLog> findByCondition(QuartzLog quartzLog, SearchVo searchVo, Pageable pageable);

    /**
     * 通过className删除
     *
     * @param jobClassName
     */
    void deleteByJobClassName(String jobClassName);
}
