/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.quartz.utils;

import jakarta.annotation.Resource;
import lombok.Generated;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import plus.hiver.common.constant.QuartzConstant;
import plus.hiver.common.exception.HiverException;
import plus.hiver.module.quartz.entity.QuartzJob;

@Component
public class SchedulerUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerUtil.class);
    @Resource
    private Scheduler scheduler;

    public static Job getClass(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        return (Job)clazz.newInstance();
    }

    public void add(QuartzJob quartzJob) {
        String string = quartzJob.getJobClassName();
        String string2 = quartzJob.getCronExpression();
        Integer n = quartzJob.getMisfirePolicy();
        String string3 = quartzJob.getParameter();
        if (!CronExpression.isValidExpression((String)string2)) {
            throw new HiverException("Cron\u8868\u8fbe\u5f0f\u975e\u6cd5");
        }
        try {
            JobDetail jobDetail = JobBuilder.newJob(SchedulerUtil.getClass(string).getClass()).withIdentity(string).usingJobData("parameter", string3).build();
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)string2);
            cronScheduleBuilder = this.handleCronScheduleMisfirePolicy(cronScheduleBuilder, n);
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(string).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
        }
        catch (SchedulerException schedulerException) {
            log.error(schedulerException.toString());
            throw new HiverException("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
        catch (Exception exception) {
            throw new HiverException("\u540e\u53f0\u627e\u4e0d\u5230\u8be5\u7c7b\u540d\u4efb\u52a1");
        }
    }

    public CronScheduleBuilder handleCronScheduleMisfirePolicy(CronScheduleBuilder cronScheduleBuilder, Integer n) {
        if (QuartzConstant.MISFIRE_IGNORE_MISFIRES.equals(n)) {
            return cronScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
        }
        if (QuartzConstant.MISFIRE_FIRE_AND_PROCEED.equals(n)) {
            return cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
        }
        return cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
    }

    public void pauseJob(QuartzJob quartzJob) {
        try {
            this.scheduler.pauseJob(JobKey.jobKey((String)quartzJob.getJobClassName()));
        }
        catch (SchedulerException schedulerException) {
            throw new HiverException("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void resumeJob(QuartzJob quartzJob) {
        try {
            this.scheduler.resumeJob(JobKey.jobKey((String)quartzJob.getJobClassName()));
        }
        catch (SchedulerException schedulerException) {
            throw new HiverException("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void delete(QuartzJob quartzJob) {
        try {
            String string = quartzJob.getJobClassName();
            this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)string));
            this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)string));
            this.scheduler.deleteJob(JobKey.jobKey((String)string));
        }
        catch (Exception exception) {
            throw new HiverException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }
}

