/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.rustfs.controller;

import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.service.SettingService;
import plus.hiver.common.utils.Base64DecodeMultipartFile;
import plus.hiver.common.utils.CommonUtil;
import plus.hiver.common.utils.IpInfoUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.module.system.vo.OssSetting;
import plus.hiver.rustfs.entity.File;
import plus.hiver.rustfs.manage.FileManageFactory;
import plus.hiver.rustfs.service.FileService;

@RestController
@Tag(name="\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3")
@PermissionTag(permission="upload:*")
@RequestMapping(value={"/hiver/upload"})
public class UploadController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadController.class);
    @Value(value="${hiver.maxUploadFile}")
    private Long maxUploadFile;
    @Resource
    private IpInfoUtil ipInfoUtil;
    @Resource
    private FileManageFactory fileManageFactory;
    @Resource
    private SettingService settingService;
    @Resource
    private FileService fileService;

    @PostMapping(value={"/file"})
    @Operation(summary="\u6587\u4ef6\u4e0a\u4f20")
    public Result upload(@RequestParam(required=false) MultipartFile multipartFile, @RequestParam(required=false) String string, @RequestParam(required=false) Long l, HttpServletRequest httpServletRequest) {
        InputStream inputStream;
        if (multipartFile == null && StrUtil.isBlank((CharSequence)string)) {
            return ResultUtil.error((String)"\u7f3a\u5c11\u6587\u4ef6\u53c2\u6570");
        }
        if (multipartFile != null && multipartFile.getSize() > this.maxUploadFile * 1024L * 1024L) {
            return ResultUtil.error((String)("\u6587\u4ef6\u5927\u5c0f\u8fc7\u5927\uff0c\u4e0d\u80fd\u8d85\u8fc7" + this.maxUploadFile + "MB"));
        }
        Setting setting = this.settingService.findByKey("OSS_USED");
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            return ResultUtil.error((Integer)501, (String)"\u60a8\u8fd8\u672a\u914d\u7f6eOSS\u5b58\u50a8\u670d\u52a1");
        }
        if (StrUtil.isNotBlank((CharSequence)string)) {
            multipartFile = Base64DecodeMultipartFile.base64Convert((String)string);
        }
        Object object = "";
        String string2 = CommonUtil.renamePic((String)multipartFile.getOriginalFilename());
        File file = new File();
        try {
            inputStream = multipartFile.getInputStream();
            object = this.fileManageFactory.getFileManage(null).inputStreamUpload(inputStream, string2, multipartFile);
            file.setLocation(this.getType(setting.getValue())).setTitle(multipartFile.getOriginalFilename()).setSize(multipartFile.getSize()).setType(multipartFile.getContentType()).setFKey(string2).setUrl((String)object).setCategoryId(l);
            this.fileService.save(file);
        }
        catch (Exception exception) {
            log.error(exception.toString());
            return ResultUtil.error((String)exception.toString());
        }
        if (setting.getValue().equals("LOCAL_OSS")) {
            inputStream = (OssSetting)new Gson().fromJson(this.settingService.findByKey("LOCAL_OSS").getValue(), OssSetting.class);
            object = inputStream.getHttp() + inputStream.getEndpoint() + "/" + file.getId();
        }
        return ResultUtil.data((Object)object);
    }

    public Integer getType(String string) {
        switch (string) {
            case "RUSTFS_OSS": {
                return 1;
            }
            case "LOCAL_OSS": {
                return 0;
            }
        }
        return -1;
    }
}

