/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.rustfs.manage.impl;

import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import jakarta.annotation.Resource;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import plus.hiver.common.constant.SettingConstant;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.service.SettingService;
import plus.hiver.module.system.vo.OssSetting;
import plus.hiver.rustfs.manage.FileManage;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;

@Component
public class RustfsManage
implements FileManage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RustfsManage.class);
    @Resource
    private SettingService settingService;
    @Resource
    private S3Client s3Client;

    @Override
    public OssSetting getOssSetting() {
        Setting setting = this.settingService.findByKey(SettingConstant.OSS_TYPE.RUSTFS_OSS.name());
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            throw new HiverException("\u60a8\u8fd8\u672a\u914d\u7f6e\u963f\u91cc\u4e91OSS\u5b58\u50a8");
        }
        return (OssSetting)new Gson().fromJson(setting.getValue(), OssSetting.class);
    }

    @Override
    public String inputStreamUpload(InputStream inputStream, String string, MultipartFile multipartFile) {
        return "";
    }

    @Override
    public String inputStreamUpload(InputStream inputStream, String string) {
        return "";
    }

    @Override
    public String renameFile(String string, String string2) {
        return "";
    }

    @Override
    public String copyFile(String string, String string2) {
        return "";
    }

    @Override
    public void deleteFile(String string) {
        this.s3Client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket("simple").key(string).build());
    }
}

