/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.rustfs.serviceimpl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import jakarta.annotation.Nullable;
import jakarta.annotation.Resource;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.constant.SettingConstant;
import plus.hiver.common.entity.User;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.service.SettingService;
import plus.hiver.common.utils.CommonUtil;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.system.vo.OssSetting;
import plus.hiver.rustfs.dao.FileDao;
import plus.hiver.rustfs.entity.File;
import plus.hiver.rustfs.manage.FileManageFactory;
import plus.hiver.rustfs.service.FileService;
import plus.hiver.rustfs.utils.FileUtil;

@Service
@Transactional
@CacheConfig(cacheNames={"file"})
public class FileServiceImpl
extends HiverBaseServiceImpl<File, Long, FileDao>
implements FileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    @Resource
    private SecurityUtil securityUtil;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;
    @Resource
    private SettingService settingService;
    @Resource
    private FileManageFactory fileManageFactory;
    @PersistenceContext
    private EntityManager entityManager;

    public FileServiceImpl(FileDao fileDao) {
        super((HiverBaseDao)fileDao);
    }

    @Cacheable(key="#id")
    public File get(Long l) {
        String string = this.redisTemplateHelper.get("file::" + l);
        if ("null".equals(string)) {
            return null;
        }
        File file = ((FileDao)this.dao).findById(l).orElse(null);
        if (file == null) {
            this.redisTemplateHelper.set("file::" + l, "null", 5L, TimeUnit.MINUTES);
        }
        return file;
    }

    @Override
    public Page<File> getFileList(final File file2, final SearchVo searchVo, PageVo pageVo, Boolean bl) {
        if (bl.booleanValue()) {
            file2.setCreateBy(this.securityUtil.getCurrUserSimple().getUsername());
        }
        Page page = ((FileDao)this.dao).findAll((Specification)new Specification<File>(){

            @Nullable
            public Predicate toPredicate(Root<File> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                DateTime dateTime;
                Path path = root.get("title");
                Path path2 = root.get("fKey");
                Path path3 = root.get("type");
                Path path4 = root.get("categoryId");
                Path path5 = root.get("createBy");
                Path path6 = root.get("isCollect");
                Path path7 = root.get("location");
                Path path8 = root.get("deleted");
                Path path9 = root.get("createTime");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)file2.getTitle())) {
                    arrayList.add(criteriaBuilder.like((Expression)path, "%" + file2.getTitle() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)file2.getFKey())) {
                    arrayList.add(criteriaBuilder.like((Expression)path2, "%" + file2.getFKey() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)file2.getType())) {
                    arrayList.add(criteriaBuilder.like((Expression)path3, "%" + file2.getType() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)file2.getCreateBy())) {
                    arrayList.add(criteriaBuilder.like((Expression)path5, "%" + file2.getCreateBy() + "%"));
                }
                if (file2.getDeleted() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path8, (Object)file2.getDeleted()));
                }
                if (file2.getLocation() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path7, (Object)file2.getLocation()));
                }
                if (file2.getIsCollect() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path6, (Object)file2.getIsCollect()));
                }
                if (file2.getCategoryId() != null && file2.getCategoryId() > 0L) {
                    arrayList.add(criteriaBuilder.equal((Expression)path4, (Object)file2.getCategoryId()));
                }
                if (StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
                    dateTime = DateUtil.parse((CharSequence)searchVo.getStartDate());
                    DateTime dateTime2 = DateUtil.parse((CharSequence)searchVo.getEndDate());
                    arrayList.add(criteriaBuilder.between((Expression)path9, (Comparable)dateTime, (Comparable)DateUtil.endOfDay((Date)dateTime2)));
                }
                dateTime = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray((T[])dateTime));
                return null;
            }
        }, PageUtil.initPage((PageVo)pageVo));
        OssSetting ossSetting = (OssSetting)new Gson().fromJson(this.settingService.findByKey(SettingConstant.OSS_TYPE.LOCAL_OSS.name()).getValue(), OssSetting.class);
        for (File file3 : page.getContent()) {
            if (file3.getLocation() != null && file3.getLocation().equals(SettingConstant.OSS_TYPE.LOCAL_OSS.ordinal())) {
                String string = ossSetting.getHttp() + ossSetting.getEndpoint() + "/";
                this.entityManager.detach((Object)file3);
                file3.setUrl(string + file3.getId());
            }
            if (!HiverConstant.DEL_FLAG_TRASH.equals(file2.getDeleted())) continue;
            if (FileUtil.isOvertime(file3.getUpdateTime()).booleanValue()) {
                this.delete(new Long[]{file3.getId()}, true);
                continue;
            }
            file3.setRestDelTime(FileUtil.getRestTime(file3.getUpdateTime()));
        }
        if (HiverConstant.DEL_FLAG_TRASH.equals(file2.getDeleted())) {
            page = new PageImpl(page.getContent().stream().filter(file -> FileUtil.isOvertime(file.getUpdateTime()) == false).collect(Collectors.toList()), page.getPageable(), (long)page.getTotalPages());
        }
        return page;
    }

    @Override
    public void trash(Long l, Boolean bl) {
        User user;
        File file = this.get(l);
        if (file.getLocation() == null) {
            throw new HiverException("\u5b58\u50a8\u4f4d\u7f6e\u672a\u77e5");
        }
        if (bl.booleanValue() && !(user = this.securityUtil.getCurrUserSimple()).getUsername().equals(file.getCreateBy())) {
            throw new HiverException("\u4f60\u65e0\u6743\u64cd\u4f5c\u6b64\u6587\u4ef6");
        }
        file.setDeleted(HiverConstant.DEL_FLAG_TRASH.equals(file.getDeleted()) ? HiverConstant.DEL_FLAG_FALSE : HiverConstant.DEL_FLAG_TRASH);
        ((FileDao)this.dao).saveAndFlush((Object)file);
    }

    @Override
    public void collect(Long l, Boolean bl) {
        User user;
        File file = this.get(l);
        if (file.getLocation() == null) {
            throw new HiverException("\u5b58\u50a8\u4f4d\u7f6e\u672a\u77e5");
        }
        if (bl.booleanValue() && !(user = this.securityUtil.getCurrUserSimple()).getUsername().equals(file.getCreateBy())) {
            throw new HiverException("\u4f60\u65e0\u6743\u64cd\u4f5c\u6b64\u6587\u4ef6");
        }
        file.setIsCollect(file.getIsCollect() == null || file.getIsCollect() == false);
        ((FileDao)this.dao).saveAndFlush((Object)file);
    }

    @Override
    @CacheEvict(key="#id")
    public void rename(Long l, String string, String string2, Boolean bl) {
        String string3;
        File file = this.get(l);
        if (file.getLocation() == null) {
            throw new HiverException("\u5b58\u50a8\u4f4d\u7f6e\u672a\u77e5");
        }
        if (bl.booleanValue() && !(string3 = this.securityUtil.getCurrUserSimple()).getUsername().equals(file.getCreateBy())) {
            throw new HiverException("\u4f60\u65e0\u6743\u64cd\u4f5c\u6b64\u6587\u4ef6");
        }
        string3 = "";
        String string4 = file.getFKey();
        if (StrUtil.isBlank((CharSequence)string)) {
            string = file.getFKey();
        }
        if (StrUtil.isBlank((CharSequence)string2)) {
            string2 = file.getTitle();
        }
        if (!string4.equals(string)) {
            if (file.getLocation().equals(SettingConstant.OSS_TYPE.LOCAL_OSS.ordinal())) {
                string4 = file.getUrl();
            }
            string3 = this.fileManageFactory.getFileManage(file.getLocation()).renameFile(string4, string);
            file.setUrl(string3);
        }
        file.setTitle(string2).setFKey(string);
        this.update(file);
    }

    @Override
    public void copy(Long l, Boolean bl) {
        String string;
        File file = this.get(l);
        if (file.getLocation() == null) {
            throw new HiverException("\u5b58\u50a8\u4f4d\u7f6e\u672a\u77e5");
        }
        if (bl.booleanValue() && !(string = this.securityUtil.getCurrUserSimple()).getUsername().equals(file.getCreateBy())) {
            throw new HiverException("\u4f60\u65e0\u6743\u64cd\u4f5c\u6b64\u6587\u4ef6");
        }
        string = file.getFKey();
        String string2 = CommonUtil.renamePic((String)string);
        if (file.getLocation().equals(SettingConstant.OSS_TYPE.LOCAL_OSS.ordinal())) {
            string = file.getUrl();
        }
        String string3 = this.fileManageFactory.getFileManage(file.getLocation()).copyFile(string, string2);
        File file2 = new File().setTitle("\u526f\u672c_" + file.getTitle()).setFKey(string2).setSize(file.getSize()).setType(file.getType()).setLocation(file.getLocation()).setUrl(string3);
        if (bl.booleanValue()) {
            file2.setCategoryId(file.getCategoryId());
        }
        this.save(file2);
    }

    @Override
    public void delete(Long[] longArray, Boolean bl) {
        for (Long l : longArray) {
            String string;
            File file = this.get(l);
            if (file.getLocation() == null) {
                throw new HiverException("\u5b58\u50a8\u4f4d\u7f6e\u672a\u77e5");
            }
            if (bl.booleanValue() && !(string = this.securityUtil.getCurrUserSimple()).getUsername().equals(file.getCreateBy())) {
                throw new HiverException("\u4f60\u65e0\u6743\u64cd\u4f5c\u6b64\u6587\u4ef6");
            }
            string = file.getFKey();
            if (file.getLocation().equals(SettingConstant.OSS_TYPE.LOCAL_OSS.ordinal())) {
                string = file.getUrl();
            }
            try {
                this.fileManageFactory.getFileManage(file.getLocation()).deleteFile(string);
            }
            catch (Exception exception) {
                log.error("\u670d\u52a1\u5668\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff0cID\uff1a" + file.getId() + " \u5b58\u50a8\u4f4d\u7f6e\uff1a" + file.getLocation());
            }
            this.delete(l);
            this.redisTemplateHelper.delete("file::" + l);
        }
    }

    @Override
    public void clearTrash() {
        User user = this.securityUtil.getCurrUserSimple();
        ((FileDao)this.dao).deleteByCreateByAndDelFlag(user.getUsername(), HiverConstant.DEL_FLAG_TRASH);
    }

    @Override
    public void deleteByCategoryId(Long l) {
        ((FileDao)this.dao).deleteByCategoryId(l);
    }
}

