/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.rustfs.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.rustfs.entity.File;
import plus.hiver.rustfs.service.FileService;

/**
 * 文件管理管理接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@RestController
@Tag(name = "文件管理管理接口")
@PermissionTag(permission = "file:*" )
@RequestMapping("/hiver/file")
public class FileController {
    @Resource
    private FileService fileService;

    @GetMapping(value = "/getByCondition")
    @Operation(summary = "多条件分页获取")
    public Result<Page<File>> getFileList(File file, SearchVo searchVo, PageVo pageVo) {
        Page<File> page = fileService.getFileList(file, searchVo, pageVo, false);
        return new ResultUtil<Page<File>>().setData(page);
    }

    @PostMapping(value = "/rename")
    @Operation(summary = "文件重命名")
    public Result renameUserFile(@RequestParam Long id,
                                 @RequestParam String newKey,
                                 @RequestParam String newTitle) {
        fileService.rename(id, newKey, newTitle, false);
        return ResultUtil.data(null);
    }

    @PostMapping(value = "/copy")
    @Operation(summary = "文件复制")
    public Result copy(@RequestParam Long id) {
        fileService.copy(id, false);
        return ResultUtil.data(null);
    }

    @PostMapping(value = "/delete")
    @Operation(summary = "文件删除")
    public Result delete(@RequestParam Long[] ids) {
        fileService.delete(ids, false);
        return ResultUtil.data(null);
    }
}
