/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.rustfs.dto;

import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * RustFS Bucket访问策略配置
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@EqualsAndHashCode
@Builder
public class BucketPolicyConfigDto {
    private String ID;
    private String Version;
    private List<Statement> Statement;

    @Data
    @EqualsAndHashCode
    @Builder
    public static class Statement {
        private String Effect;
        private Principal Principal;
        private String[] Action;
        private String[] Resource;

    }

    @Data
    @EqualsAndHashCode
    @Builder
    public static class Principal{
        private String[] AWS;
    }
}
