/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.rustfs.utils;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;

import java.util.Date;

/**
 * 文件工具类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public class FileUtil {
    /**
     * 自动删除天数
     */
    private static final Integer AUTO_DEL_DAY = 7;

    public static Boolean isOvertime(Date time) {
        if (time == null) {
            return false;
        }
        Date curr = DateUtil.date();
        Date timeout = DateUtil.offset(time, DateField.DAY_OF_MONTH, AUTO_DEL_DAY);
        int ret = DateUtil.compare(curr, timeout);
        return ret > 0;
    }

    public static String getRestTime(Date time) {
        if (time == null) {
            return "";
        }
        String formatBetween = "";
        Date curr = DateUtil.date();
        Date timeout = DateUtil.offset(time, DateField.DAY_OF_MONTH, AUTO_DEL_DAY);
        Long betweenHour = DateUtil.between(curr, timeout, DateUnit.HOUR);
        if (betweenHour > 24) {
            formatBetween = DateUtil.between(curr, timeout, DateUnit.DAY) + 1 + "天";
        } else if (betweenHour > 1 && betweenHour <= 24) {
            formatBetween = DateUtil.between(curr, timeout, DateUnit.HOUR) + 1 + "小时";
        } else {
            formatBetween = DateUtil.between(curr, timeout, DateUnit.MINUTE) + 1 + "分";
        }
        return formatBetween;
    }
}
