/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.rustfs.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.entity.User;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.utils.CommonUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.rustfs.entity.File;
import plus.hiver.rustfs.entity.FileCategory;
import plus.hiver.rustfs.service.FileCategoryService;
import plus.hiver.rustfs.service.FileService;

@RestController
@Tag(name="\u6587\u4ef6\u5206\u7c7b\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="fileCategory:*")
@RequestMapping(value={"/hiver/fileCategory"})
@Transactional
public class FileCategoryController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileCategoryController.class);
    @Resource
    private FileCategoryService fileCategoryService;
    @Resource
    private FileService fileService;
    @Resource
    private SecurityUtil securityUtil;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @GetMapping(value={"/getByCondition"})
    @Operation(summary="\u591a\u6761\u4ef6\u83b7\u53d6")
    public Result<List<FileCategory>> getByCondition(@RequestParam(required=false) Long l, @RequestParam(required=false) String string, @RequestParam(required=false, defaultValue="0") Integer n, @RequestParam(required=false) Boolean bl, @RequestParam(required=false, defaultValue="sortOrder") String string2, @RequestParam(required=false, defaultValue="asc") String string3) {
        User user = this.securityUtil.getCurrUser();
        FileCategory fileCategory = new FileCategory().setParentId(l).setIsCollect(bl).setTitle(string);
        fileCategory.setCreateBy(user.getUsername());
        fileCategory.setDeleted(n);
        List<FileCategory> list = this.fileCategoryService.findByCondition(fileCategory, string2, string3);
        this.setInfo(list);
        return new ResultUtil().setData(list);
    }

    @PostMapping(value={"/trash"})
    @Operation(summary="\u7528\u6237\u6587\u4ef6\u5939\u56de\u6536\u7ad9\u64cd\u4f5c")
    public Result trash(@RequestParam Long l) {
        FileCategory fileCategory = (FileCategory)this.fileCategoryService.get(l);
        User user = this.securityUtil.getCurrUserSimple();
        if (!user.getUsername().equals(fileCategory.getCreateBy())) {
            throw new HiverException("\u4f60\u65e0\u6743\u64cd\u4f5c\u6b64\u6587\u4ef6\u5939");
        }
        fileCategory.setDeleted(HiverConstant.DEL_FLAG_TRASH.equals(fileCategory.getDeleted()) ? HiverConstant.DEL_FLAG_FALSE : HiverConstant.DEL_FLAG_TRASH);
        this.fileCategoryService.update(fileCategory);
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/collect"})
    @Operation(summary="\u7528\u6237\u6587\u4ef6\u5939\u6536\u85cf")
    public Result collect(@RequestParam Long l) {
        FileCategory fileCategory = (FileCategory)this.fileCategoryService.get(l);
        User user = this.securityUtil.getCurrUserSimple();
        if (!user.getUsername().equals(fileCategory.getCreateBy())) {
            throw new HiverException("\u4f60\u65e0\u6743\u64cd\u4f5c\u6b64\u6587\u4ef6\u5939");
        }
        fileCategory.setIsCollect(fileCategory.getIsCollect() == null ? true : fileCategory.getIsCollect() == false);
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/rename"})
    @Operation(summary="\u7528\u6237\u6587\u4ef6\u5939\u91cd\u547d\u540d")
    public Result rename(@RequestParam Long l, @RequestParam String string) {
        FileCategory fileCategory = (FileCategory)this.fileCategoryService.get(l);
        User user = this.securityUtil.getCurrUserSimple();
        if (!user.getUsername().equals(fileCategory.getCreateBy())) {
            throw new HiverException("\u4f60\u65e0\u6743\u64cd\u4f5c\u6b64\u6587\u4ef6\u5939");
        }
        fileCategory.setTitle(string);
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u6dfb\u52a0")
    public Result add(@RequestBody FileCategory fileCategory) {
        FileCategory fileCategory2;
        this.fileCategoryService.save(fileCategory);
        if (!("0".equals(fileCategory.getParentId()) || (fileCategory2 = (FileCategory)this.fileCategoryService.get(fileCategory.getParentId())).getIsParent() != null && fileCategory2.getIsParent().booleanValue())) {
            fileCategory2.setIsParent(true);
            this.fileCategoryService.update(fileCategory2);
        }
        return ResultUtil.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u7f16\u8f91")
    public Result edit(@RequestBody FileCategory fileCategory) {
        if (fileCategory.getId().equals(fileCategory.getParentId())) {
            return ResultUtil.error((String)"\u4e0a\u7ea7\u8282\u70b9\u4e0d\u80fd\u4e3a\u81ea\u5df1");
        }
        User user = this.securityUtil.getCurrUserSimple();
        FileCategory fileCategory2 = (FileCategory)this.fileCategoryService.get(fileCategory.getId());
        if (!user.getUsername().equals(fileCategory2.getCreateBy())) {
            return ResultUtil.error((String)"\u4f60\u65e0\u6743\u64cd\u4f5c\u6b64\u6587\u4ef6\u5939");
        }
        Long l = fileCategory2.getParentId();
        this.fileCategoryService.update(fileCategory);
        if (!"0".equals(l) && !l.equals(fileCategory.getParentId())) {
            FileCategory fileCategory3 = (FileCategory)this.fileCategoryService.get(l);
            List<FileCategory> list = this.fileCategoryService.findByParentId(fileCategory3.getId(), HiverConstant.DEL_FLAG_FALSE, user.getUsername());
            if (fileCategory3 != null && (list == null || list.isEmpty())) {
                fileCategory3.setIsParent(false);
                this.fileCategoryService.update(fileCategory3);
            }
        }
        return ResultUtil.success((String)"\u7f16\u8f91\u6210\u529f");
    }

    @PostMapping(value={"/moveByIds"})
    @Operation(summary="\u6279\u91cf\u4fee\u6539\u5206\u7c7b\uff08\u79fb\u52a8\uff09")
    public Result moveByIds(@RequestParam Long[] longArray, @RequestParam Long l) {
        User user = this.securityUtil.getCurrUser();
        if (!"0".equals(l)) {
            FileCategory object = (FileCategory)this.fileCategoryService.get(l);
            if (!user.getUsername().equals(object.getCreateBy())) {
                return ResultUtil.error((String)"\u4f60\u65e0\u6743\u79fb\u52a8\u81f3\u8be5\u6587\u4ef6\u5939");
            }
        }
        for (Long l2 : longArray) {
            File file = (File)this.fileService.get(l2);
            if (l.equals(file.getCategoryId())) continue;
            if (!user.getUsername().equals(file.getCreateBy())) {
                return ResultUtil.error((String)"\u4f60\u65e0\u6743\u64cd\u4f5c\u6b64\u6587\u4ef6");
            }
            file.setCategoryId(l);
            this.fileService.save(file);
            this.redisTemplateHelper.delete("file::" + l2);
        }
        return ResultUtil.success((String)"\u6279\u91cf\u79fb\u52a8\u6587\u4ef6\u6210\u529f");
    }

    @PostMapping(value={"/delByIds"})
    @Operation(summary="\u6279\u91cf\u901a\u8fc7id\u5220\u9664")
    public Result delByIds(@RequestParam Long[] longArray) {
        User user = this.securityUtil.getCurrUser();
        for (Long l : longArray) {
            this.deleteRecursion(l, longArray, user.getUsername());
        }
        return ResultUtil.success((String)"\u6279\u91cf\u901a\u8fc7id\u5220\u9664\u6570\u636e\u6210\u529f");
    }

    @GetMapping(value={"/clearTrash"})
    @Operation(summary="\u6e05\u7a7a\u56de\u6536\u7ad9")
    public Result clearTrash() {
        Long[] longArray;
        User user = this.securityUtil.getCurrUser();
        List<FileCategory> list = this.fileCategoryService.findByParentId(null, HiverConstant.DEL_FLAG_TRASH, user.getUsername());
        for (Long l : longArray = (Long[])list.stream().map(HiverBaseEntity::getId).toArray(Long[]::new)) {
            this.deleteRecursion(l, longArray, user.getUsername());
        }
        return ResultUtil.success((String)"\u6e05\u7a7a\u6587\u4ef6\u5939\u56de\u6536\u7ad9\u6210\u529f");
    }

    public void deleteRecursion(Long l, Long[] longArray, String string) {
        List<FileCategory> list;
        FileCategory fileCategory = (FileCategory)this.fileCategoryService.get(l);
        if (!string.equals(fileCategory.getCreateBy())) {
            throw new HiverException("\u4f60\u65e0\u6743\u64cd\u4f5c\u6b64\u6587\u4ef6\u5939");
        }
        FileCategory fileCategory2 = null;
        if (fileCategory.getParentId() > 0L) {
            fileCategory2 = (FileCategory)this.fileCategoryService.findById(fileCategory.getParentId());
        }
        this.fileCategoryService.delete(l);
        this.fileService.deleteByCategoryId(l);
        if (fileCategory2 != null && ((list = this.fileCategoryService.findByParentId(fileCategory2.getId(), null, string)) == null || list.isEmpty())) {
            fileCategory2.setIsParent(false);
            this.fileCategoryService.update(fileCategory2);
        }
        list = this.fileCategoryService.findByParentId(l, null, string);
        for (FileCategory fileCategory3 : list) {
            if (CommonUtil.judgeIds((Long)fileCategory3.getId(), (Long[])longArray).booleanValue()) continue;
            this.deleteRecursion(fileCategory3.getId(), longArray, string);
        }
    }

    @GetMapping(value={"/search"})
    @Operation(summary="\u540d\u79f0\u6a21\u7cca\u641c\u7d22")
    public Result<List<FileCategory>> searchByTitle(@RequestParam String string) {
        User user = this.securityUtil.getCurrUser();
        List<FileCategory> list = this.fileCategoryService.findByTitleLikeAndCreateBy("%" + string + "%", user.getUsername());
        this.setInfo(list);
        return new ResultUtil().setData(list);
    }

    public void setInfo(List<FileCategory> list) {
        list.forEach(fileCategory -> {
            if (!"0".equals(fileCategory.getParentId())) {
                FileCategory fileCategory2 = (FileCategory)this.fileCategoryService.get(fileCategory.getParentId());
                fileCategory.setParentTitle(fileCategory2.getTitle());
            } else {
                fileCategory.setParentTitle("\u4e00\u7ea7\u76ee\u5f55");
            }
        });
    }
}

