/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.rustfs.manage;

import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;
import plus.hiver.common.constant.SettingConstant;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.service.SettingService;
import plus.hiver.rustfs.manage.FileManage;
import plus.hiver.rustfs.manage.impl.LocalFileManage;
import plus.hiver.rustfs.manage.impl.RustfsManage;

@Component
public class FileManageFactory {
    @Resource
    private SettingService settingService;
    @Resource
    private LocalFileManage localFileManage;
    @Resource
    private RustfsManage rustfsManage;
    private static volatile Map<String, FileManage> fileManages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FileManage> getFileManages() {
        if (fileManages == null) {
            FileManageFactory fileManageFactory = this;
            synchronized (fileManageFactory) {
                if (fileManages == null) {
                    fileManages = new HashMap<String, FileManage>(16);
                    fileManages.put(SettingConstant.OSS_TYPE.LOCAL_OSS.name(), this.localFileManage);
                    fileManages.put(SettingConstant.OSS_TYPE.RUSTFS_OSS.name(), this.rustfsManage);
                }
            }
        }
        return fileManages;
    }

    public FileManage getFileManage() {
        return this.getFileManage(null);
    }

    public FileManage getFileManage(Integer n) {
        Setting setting = this.settingService.findByKey("OSS_USED");
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            throw new HiverException("\u60a8\u8fd8\u672a\u914d\u7f6eOSS\u5b58\u50a8\u670d\u52a1");
        }
        String string = setting.getValue();
        Map<String, FileManage> map = this.getFileManages();
        for (Map.Entry<String, FileManage> entry : map.entrySet()) {
            String string2 = entry.getKey();
            FileManage fileManage = entry.getValue();
            if ((!string.equals(string2) || n != null) && !string2.equals(SettingConstant.OSS_TYPE.getName((Integer)n))) continue;
            return fileManage;
        }
        throw new HiverException("\u6682\u4e0d\u652f\u6301\u8be5\u5b58\u50a8\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
    }
}

