/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.rustfs.manage.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import plus.hiver.common.constant.SettingConstant;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.service.SettingService;
import plus.hiver.module.system.vo.OssSetting;
import plus.hiver.rustfs.manage.FileManage;

@Component
public class LocalFileManage
implements FileManage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalFileManage.class);
    @Resource
    private SettingService settingService;

    public static void view(String string, HttpServletResponse httpServletResponse) {
        File file = new File(string);
        if (!file.exists()) {
            throw new HiverException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            int n;
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                servletOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            log.error(iOException.toString());
            throw new HiverException("\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519");
        }
    }

    @Override
    public OssSetting getOssSetting() {
        Setting setting = this.settingService.findByKey(SettingConstant.OSS_TYPE.LOCAL_OSS.name());
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            throw new HiverException("\u60a8\u8fd8\u672a\u914d\u7f6e\u672c\u5730\u5b58\u50a8");
        }
        return (OssSetting)new Gson().fromJson(setting.getValue(), OssSetting.class);
    }

    @Override
    public String inputStreamUpload(InputStream inputStream, String string, MultipartFile multipartFile) {
        File file;
        OssSetting ossSetting = this.getOssSetting();
        DateTime dateTime = DateUtil.date();
        String string2 = ossSetting.getFilePath() + "/" + dateTime.year() + "/" + dateTime.monthBaseOne() + "/" + dateTime.dayOfMonth();
        File file2 = new File(string2);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if ((file = new File(string2 + "/" + string)).exists()) {
            throw new HiverException("\u6587\u4ef6\u540d\u5df2\u5b58\u5728");
        }
        try {
            multipartFile.transferTo(file);
            return string2 + "/" + string;
        }
        catch (IOException iOException) {
            log.error(iOException.toString());
            throw new HiverException("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519");
        }
    }

    @Override
    public String inputStreamUpload(InputStream inputStream, String string) {
        File file;
        OssSetting ossSetting = this.getOssSetting();
        DateTime dateTime = DateUtil.date();
        String string2 = ossSetting.getFilePath() + "/" + dateTime.year() + "/" + dateTime.monthBaseOne() + "/" + dateTime.dayOfMonth();
        File file2 = new File(string2);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if ((file = new File(string2 + "/" + string)).exists()) {
            throw new HiverException("\u6587\u4ef6\u540d\u5df2\u5b58\u5728");
        }
        try {
            int n;
            byte[] byArray = new byte[1024];
            FileOutputStream fileOutputStream = new FileOutputStream(string2 + "/" + string);
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
            return string2 + "/" + string;
        }
        catch (IOException iOException) {
            log.error(iOException.toString());
            throw new HiverException("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519");
        }
    }

    @Override
    public String renameFile(String string, String string2) {
        File file = new File(string);
        FileUtil.rename((File)file, (String)string2, (boolean)false, (boolean)true);
        return file.getParentFile() + "/" + string2;
    }

    @Override
    public String copyFile(String string, String string2) {
        File file = new File(string);
        String string3 = file.getParentFile() + "/" + string2;
        FileUtil.copy((File)file, (File)new File(string3), (boolean)true);
        return string3;
    }

    @Override
    public void deleteFile(String string) {
        FileUtil.del((File)new File(string));
    }
}

