/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.rustfs.serviceimpl;

import cn.hutool.core.util.StrUtil;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.rustfs.dao.FileCategoryDao;
import plus.hiver.rustfs.entity.FileCategory;
import plus.hiver.rustfs.service.FileCategoryService;
import plus.hiver.rustfs.utils.FileUtil;

@Service
@Transactional
public class FileCategoryServiceImpl
extends HiverBaseServiceImpl<FileCategory, Long, FileCategoryDao>
implements FileCategoryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileCategoryServiceImpl.class);

    public FileCategoryServiceImpl(FileCategoryDao fileCategoryDao) {
        super((HiverBaseDao)fileCategoryDao);
    }

    @Override
    public List<FileCategory> findByCondition(final FileCategory fileCategory2, String string, String string2) {
        Sort.Direction direction = StrUtil.isBlank((CharSequence)string2) ? Sort.Direction.DESC : Sort.Direction.valueOf((String)string2.toUpperCase());
        if (StrUtil.isBlank((CharSequence)string)) {
            string = "sortOrder";
        }
        List<FileCategory> list = ((FileCategoryDao)this.dao).findAll((Specification)new Specification<FileCategory>(){

            public Predicate toPredicate(Root<FileCategory> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                Path path = root.get("parentId");
                Path path2 = root.get("title");
                Path path3 = root.get("deleted");
                Path path4 = root.get("isCollect");
                Path path5 = root.get("createBy");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (fileCategory2.getParentId() != null && fileCategory2.getParentId() > 0L) {
                    arrayList.add(criteriaBuilder.equal((Expression)path, (Object)fileCategory2.getParentId()));
                }
                if (StrUtil.isNotBlank((CharSequence)fileCategory2.getTitle())) {
                    arrayList.add(criteriaBuilder.like((Expression)path2, "%" + fileCategory2.getTitle() + "%"));
                }
                if (fileCategory2.getDeleted() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path3, (Object)fileCategory2.getDeleted()));
                }
                if (fileCategory2.getIsCollect() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path4, (Object)fileCategory2.getIsCollect()));
                }
                if (StrUtil.isNotBlank((CharSequence)fileCategory2.getCreateBy())) {
                    arrayList.add(criteriaBuilder.equal((Expression)path5, (Object)fileCategory2.getCreateBy()));
                }
                Predicate[] predicateArray = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray(predicateArray));
                return null;
            }
        }, Sort.by((Sort.Direction)direction, (String[])new String[]{string}));
        if (HiverConstant.DEL_FLAG_TRASH.equals(fileCategory2.getDeleted())) {
            list.forEach(fileCategory -> {
                if (FileUtil.isOvertime(fileCategory.getUpdateTime()).booleanValue()) {
                    this.delete(fileCategory.getId());
                } else {
                    fileCategory.setRestDelTime(FileUtil.getRestTime(fileCategory.getUpdateTime()));
                }
            });
            list = list.stream().filter(fileCategory -> FileUtil.isOvertime(fileCategory.getUpdateTime()) == false).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public List<FileCategory> findByParentId(Long l, Integer n, String string) {
        FileCategory fileCategory = new FileCategory().setParentId(l);
        fileCategory.setDeleted(n);
        fileCategory.setCreateBy(string);
        return this.findByCondition(fileCategory, null, null);
    }

    @Override
    public List<FileCategory> findByTitleLikeAndCreateBy(String string, String string2) {
        return ((FileCategoryDao)this.dao).findByTitleLikeAndCreateByOrderBySortOrder(string, string2);
    }
}

