/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.rustfs.dao;

import org.springframework.stereotype.Repository;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.rustfs.entity.FileCategory;

import java.util.List;

/**
 * 文件分类数据处理层
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Repository
public interface FileCategoryDao extends HiverBaseDao<FileCategory, Long> {
    /**
     * 通过名称和创建人模糊搜索
     *
     * @param title
     * @param createBy
     * @return
     */
    List<FileCategory> findByTitleLikeAndCreateByOrderBySortOrder(String title, String createBy);
}
