/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.rustfs.service;

import plus.hiver.common.base.HiverBaseService;
import plus.hiver.rustfs.entity.FileCategory;

import java.util.List;

/**
 * 文件分类接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface FileCategoryService extends HiverBaseService<FileCategory, Long> {
    /**
     * 多条件获取
     *
     * @param fileCategory 条件
     * @param sort 排序字段
     * @param order 排序方式
     * @return 结果
     */
    List<FileCategory> findByCondition(FileCategory fileCategory, String sort, String order);

    /**
     * 通过父id和创建人获取
     *
     * @param parentId 父id
     * @param deleted 删除标识
     * @param createBy 创建人
     * @return 结果
     */
    List<FileCategory> findByParentId(Long parentId, Integer deleted, String createBy);

    /**
     * 通过名称和创建人模糊搜索
     *
     * @param title     标题
     * @param createBy  创建人
     * @return 结果
     */
    List<FileCategory> findByTitleLikeAndCreateBy(String title, String createBy);
}
