/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.rustfs.controller;

import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.service.SettingService;
import plus.hiver.rustfs.entity.File;
import plus.hiver.rustfs.manage.impl.LocalFileManage;
import plus.hiver.rustfs.service.FileService;

@RestController
@Tag(name="\u6587\u4ef6\u7ba1\u7406\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="file:*")
@RequestMapping(value={"/hiver/file"})
public class LocalFileViewController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalFileViewController.class);
    @Resource
    private FileService fileService;
    @Resource
    private SettingService settingService;

    @GetMapping(value={"/view/{id}"})
    @Operation(summary="\u672c\u5730\u5b58\u50a8\u9884\u89c8\u6587\u4ef6")
    public void view(@PathVariable Long l, @RequestParam(required=false) String string, @RequestParam(required=false, defaultValue="false") Boolean bl, @RequestParam(required=false, defaultValue="UTF-8") String string2, HttpServletResponse httpServletResponse) throws IOException {
        File file = (File)this.fileService.get(l);
        if (file == null) {
            throw new HiverException("\u6587\u4ef6ID\uff1a" + l + "\u4e0d\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)string)) {
            string = file.getFKey();
        }
        if (!bl.booleanValue()) {
            httpServletResponse.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(string, StandardCharsets.UTF_8));
        }
        httpServletResponse.setContentLengthLong(file.getSize().longValue());
        httpServletResponse.setContentType(file.getType() + ";charset=" + string2);
        httpServletResponse.addHeader("Accept-Ranges", "bytes");
        if (file.getSize() != null && file.getSize() > 0L) {
            httpServletResponse.addHeader("Content-Range", "bytes 0-" + (file.getSize() - 1L) + "/" + file.getSize());
        }
        httpServletResponse.setBufferSize(0xA00000);
        LocalFileManage.view(file.getUrl(), httpServletResponse);
    }
}

