/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.rustfs.manage.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.google.gson.Gson;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import plus.hiver.common.constant.SettingConstant;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.service.SettingService;
import plus.hiver.module.system.vo.OssSetting;
import plus.hiver.rustfs.dto.BucketPolicyConfigDto;
import plus.hiver.rustfs.dto.RustFSUploadResult;
import plus.hiver.rustfs.manage.FileManage;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

@Component
public class RustfsManage
implements FileManage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RustfsManage.class);
    @Resource
    private SettingService settingService;
    @Resource
    private S3Client s3Client;

    @Override
    public OssSetting getOssSetting() {
        Setting setting = this.settingService.findByKey(SettingConstant.OSS_TYPE.RUSTFS_OSS.name());
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            throw new HiverException("\u60a8\u8fd8\u672a\u914d\u7f6eRustfs\u5b58\u50a8");
        }
        return (OssSetting)new Gson().fromJson(setting.getValue(), OssSetting.class);
    }

    @Override
    public String inputStreamUpload(InputStream inputStream, String string, MultipartFile multipartFile) {
        Object object;
        OssSetting ossSetting = this.getOssSetting();
        if (!this.bucketExists(ossSetting.getBucket())) {
            this.s3Client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(ossSetting.getBucket()).build());
            log.info("Bucket created: {}", (Object)ossSetting.getBucket());
            object = JSONUtil.toJsonStr((Object)this.createBucketPolicyConfigDto(ossSetting.getBucket()));
            log.info((String)object);
            PutBucketPolicyRequest putBucketPolicyRequest = (PutBucketPolicyRequest)PutBucketPolicyRequest.builder().bucket(ossSetting.getBucket()).policy((String)object).build();
            this.s3Client.putBucketPolicy(putBucketPolicyRequest);
        } else {
            log.info("Bucket already exists.");
        }
        try {
            this.s3Client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(ossSetting.getBucket()).key(multipartFile.getOriginalFilename()).contentType(multipartFile.getContentType()).build(), RequestBody.fromInputStream((InputStream)multipartFile.getInputStream(), (long)multipartFile.getSize()));
            object = new RustFSUploadResult();
            ((RustFSUploadResult)object).setName(multipartFile.getOriginalFilename());
            ((RustFSUploadResult)object).setUrl(ossSetting.getEndpoint() + "/" + string + "/" + multipartFile.getOriginalFilename());
            return ((RustFSUploadResult)object).getUrl();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public String inputStreamUpload(InputStream inputStream, String string) {
        String string2;
        Object object;
        OssSetting ossSetting = this.getOssSetting();
        if (!this.bucketExists(ossSetting.getBucket())) {
            this.s3Client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(ossSetting.getBucket()).build());
            log.info("Bucket created: {}", (Object)ossSetting.getBucket());
            object = JSONUtil.toJsonStr((Object)this.createBucketPolicyConfigDto(ossSetting.getBucket()));
            log.info((String)object);
            string2 = (PutBucketPolicyRequest)PutBucketPolicyRequest.builder().bucket(ossSetting.getBucket()).policy((String)object).build();
            this.s3Client.putBucketPolicy((PutBucketPolicyRequest)string2);
        } else {
            log.info("Bucket already exists.");
        }
        try {
            object = Paths.get(string, new String[0]);
            string2 = Files.probeContentType((Path)object);
            long l = Files.size((Path)object);
            String string3 = object.getFileName().toString();
            PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(ossSetting.getBucket()).key(string).contentType(string2).contentLength(Long.valueOf(l)).build();
            this.s3Client.putObject(putObjectRequest, RequestBody.fromFile((Path)object));
            RustFSUploadResult rustFSUploadResult = new RustFSUploadResult();
            rustFSUploadResult.setName(string3);
            rustFSUploadResult.setUrl(ossSetting.getEndpoint() + "/" + ossSetting.getBucket() + "/" + string3);
            return rustFSUploadResult.getUrl();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public String renameFile(String string, String string2) {
        OssSetting ossSetting = this.getOssSetting();
        if (!this.objectExists(ossSetting.getBucket(), string)) {
            throw new RuntimeException("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728: " + string);
        }
        if (this.objectExists(ossSetting.getBucket(), string2)) {
            throw new RuntimeException("\u76ee\u6807\u6587\u4ef6\u5df2\u5b58\u5728: " + string2);
        }
        this.copyFile(string, string2);
        this.deleteFile(string);
        return string2;
    }

    @Override
    public String copyFile(String string, String string2) {
        OssSetting ossSetting = this.getOssSetting();
        if (!this.objectExists(ossSetting.getBucket(), string)) {
            throw new RuntimeException("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728: " + string);
        }
        CopyObjectRequest copyObjectRequest = (CopyObjectRequest)CopyObjectRequest.builder().sourceBucket(ossSetting.getBucket()).sourceKey(string).destinationBucket(ossSetting.getBucket()).destinationKey(string2).build();
        this.s3Client.copyObject(copyObjectRequest);
        return string2;
    }

    @Override
    public void deleteFile(String string) {
        OssSetting ossSetting = this.getOssSetting();
        this.s3Client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(ossSetting.getBucket()).key(string).build());
    }

    private boolean objectExists(String string, String string2) {
        try {
            this.s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(string).key(string2).build());
            return true;
        }
        catch (S3Exception s3Exception) {
            if (s3Exception.statusCode() == 404) {
                return false;
            }
            throw s3Exception;
        }
    }

    private boolean bucketExists(String string) {
        try {
            this.s3Client.headBucket(builder -> builder.bucket(string));
            return true;
        }
        catch (NoSuchBucketException noSuchBucketException) {
            return false;
        }
    }

    private BucketPolicyConfigDto createBucketPolicyConfigDto(String string) {
        BucketPolicyConfigDto.Statement statement = BucketPolicyConfigDto.Statement.builder().Effect("Allow").Principal(BucketPolicyConfigDto.Principal.builder().AWS(new String[]{"*"}).build()).Action(new String[]{"s3:GetObject"}).Resource(new String[]{"arn:aws:s3:::" + string + "/*"}).build();
        return BucketPolicyConfigDto.builder().Version("2012-10-17").Statement(CollUtil.toList((Object[])new BucketPolicyConfigDto.Statement[]{statement})).build();
    }
}

