/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.rustfs.manage;

import org.springframework.web.multipart.MultipartFile;
import plus.hiver.module.system.vo.OssSetting;

import java.io.InputStream;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface FileManage {
    /**
     * 获取配置
     *
     * @return 配置
     */
    OssSetting getOssSetting();

    /**
     * 文件流上传
     *
     * @param inputStream 输入流
     * @param key         路径
     * @param file        文件
     * @return 结果
     */
    String inputStreamUpload(InputStream inputStream, String key, MultipartFile file);

    /**
     * 文件流上传
     *
     * @param inputStream 输入流
     * @param fileName    文件名
     * @return 结果
     */
    String inputStreamUpload(InputStream inputStream, String fileName);

    /**
     * 重命名文件
     *
     * @param fromKey 原key
     * @param toKey   新key
     * @return 结果
     */
    String renameFile(String fromKey, String toKey);

    /**
     * 拷贝文件
     *
     * @param fromKey 原key
     * @param toKey   新key
     * @return 结果
     */
    String copyFile(String fromKey, String toKey);

    /**
     * 删除文件
     *
     * @param key 文件名
     */
    void deleteFile(String key);
}
