/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.rustfs.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.rustfs.entity.File;
import plus.hiver.rustfs.service.FileService;

@RestController
@Tag(name="\u6587\u4ef6\u7ba1\u7406\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="file:*")
@RequestMapping(value={"/hiver/file/user"})
public class FileUserController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUserController.class);
    @Resource
    private FileService fileService;

    @GetMapping(value={"/getByCondition"})
    @Operation(summary="\u7528\u6237\u591a\u6761\u4ef6\u5206\u9875\u83b7\u53d6")
    public Result<Page<File>> getFileList(File file, SearchVo searchVo, PageVo pageVo) {
        Page<File> page = this.fileService.getFileList(file, searchVo, pageVo, true);
        return new ResultUtil().setData(page);
    }

    @PostMapping(value={"/trash"})
    @Operation(summary="\u7528\u6237\u6587\u4ef6\u56de\u6536\u7ad9\u64cd\u4f5c")
    public Result trash(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            this.fileService.trash(l, true);
        }
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/collect"})
    @Operation(summary="\u7528\u6237\u6587\u4ef6\u6536\u85cf")
    public Result collect(@RequestParam Long l) {
        this.fileService.collect(l, true);
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/rename"})
    @Operation(summary="\u7528\u6237\u6587\u4ef6\u91cd\u547d\u540d")
    public Result renameUserFile(@RequestParam Long l, @RequestParam String string) {
        this.fileService.rename(l, null, string, true);
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/copy"})
    @Operation(summary="\u7528\u6237\u6587\u4ef6\u590d\u5236")
    public Result copy(@RequestParam Long l) {
        this.fileService.copy(l, true);
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/delete"})
    @Operation(summary="\u7528\u6237\u6587\u4ef6\u5220\u9664")
    public Result delete(@RequestParam Long[] longArray) {
        this.fileService.delete(longArray, true);
        return ResultUtil.data(null);
    }

    @RequestMapping(value={"/clearTrash"}, method={RequestMethod.GET})
    @Operation(summary="\u6e05\u7a7a\u56de\u6536\u7ad9")
    public Result clearTrash() {
        this.fileService.clearTrash();
        return ResultUtil.success((String)"\u6e05\u7a7a\u6587\u4ef6\u56de\u6536\u7ad9\u6210\u529f");
    }
}

