/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.rustfs.dao;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.rustfs.entity.File;

/**
 * 文件管理数据处理层
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Repository
public interface FileDao extends HiverBaseDao<File, Long> {
    /**
     * 清空回收站
     *
     * @param username
     * @param delFlag
     */
    @Modifying
    @Query("delete from File f where f.createBy = ?1 and f.deleted = ?2")
    void deleteByCreateByAndDelFlag(String username, Integer delFlag);

    /**
     * 通过categoryId删除
     *
     * @param categoryId
     */
    @Modifying
    @Query("delete from File f where f.categoryId = ?1")
    void deleteByCategoryId(Long categoryId);
}
