/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.rustfs.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.TenantId;
import plus.hiver.common.base.HiverBaseEntity;

/**
 * 文件实体类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_file")
@TableName("t_file")
@Tag(name = "文件")
public class File extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @TenantId
    @Schema(description = "租户ID")
    @TableField(fill = FieldFill.INSERT)
    private Long tenantId;

    @Schema(description = "原文件名")
    private String title;

    @Schema(description = "存储文件名")
    private String fKey;

    @Schema(description = "大小")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long size;

    @Schema(description = "文件类型")
    private String type;

    @Schema(description = "路径")
    private String url;

    @Schema(description = "存储位置 0本地 1Rustfs系统")
    private Integer location;

    @Schema(description = "类别id")
    private Long categoryId;

    @Schema(description = "收藏")
    private Boolean isCollect;

    @Transient
    @TableField(exist = false)
    @Schema(description = "上传者用户名")
    private String nickname;

    @Transient
    @TableField(exist = false)
    @Schema(description = "剩余删除时间")
    private String restDelTime;
}
