/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.rustfs.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.rustfs.dto.BucketPolicyConfigDto;
import plus.hiver.rustfs.dto.RustFSUploadResult;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@RestController
@Tag(name="RustFS\u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406")
@PermissionTag(permission="rustfs:*")
@RequestMapping(value={"/hiver/rustfs"})
public class RustFSController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RustFSController.class);
    @Autowired
    private S3Client s3Client;
    @Value(value="${rustfs.bucketName}")
    private String BUCKET_NAME;
    @Value(value="${rustfs.endpoint}")
    private String ENDPOINT;

    @Operation(summary="\u6587\u4ef6\u4e0a\u4f20")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    public Result upload(@RequestPart(value="file") MultipartFile multipartFile) {
        Object object;
        if (!this.bucketExists(this.BUCKET_NAME)) {
            this.s3Client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(this.BUCKET_NAME).build());
            log.info("Bucket created: {}", (Object)this.BUCKET_NAME);
            object = JSONUtil.toJsonStr((Object)this.createBucketPolicyConfigDto(this.BUCKET_NAME));
            log.info((String)object);
            PutBucketPolicyRequest putBucketPolicyRequest = (PutBucketPolicyRequest)PutBucketPolicyRequest.builder().bucket(this.BUCKET_NAME).policy((String)object).build();
            this.s3Client.putBucketPolicy(putBucketPolicyRequest);
        } else {
            log.info("Bucket already exists.");
        }
        try {
            this.s3Client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.BUCKET_NAME).key(multipartFile.getOriginalFilename()).contentType(multipartFile.getContentType()).build(), RequestBody.fromInputStream((InputStream)multipartFile.getInputStream(), (long)multipartFile.getSize()));
            object = new RustFSUploadResult();
            ((RustFSUploadResult)object).setName(multipartFile.getOriginalFilename());
            ((RustFSUploadResult)object).setUrl(this.ENDPOINT + "/" + this.BUCKET_NAME + "/" + multipartFile.getOriginalFilename());
            return ResultUtil.data((Object)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return ResultUtil.error((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @Operation(summary="\u6587\u4ef6\u5220\u9664")
    @PostMapping(value={"/delete"})
    @ResponseBody
    public Result delete(@RequestParam(value="objectName") String string) {
        this.s3Client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.BUCKET_NAME).key(string).build());
        return ResultUtil.success((String)"\u5220\u9664\u6210\u529f");
    }

    private boolean bucketExists(String string) {
        try {
            this.s3Client.headBucket(builder -> builder.bucket(string));
            return true;
        }
        catch (NoSuchBucketException noSuchBucketException) {
            return false;
        }
    }

    private BucketPolicyConfigDto createBucketPolicyConfigDto(String string) {
        BucketPolicyConfigDto.Statement statement = BucketPolicyConfigDto.Statement.builder().Effect("Allow").Principal(BucketPolicyConfigDto.Principal.builder().AWS(new String[]{"*"}).build()).Action(new String[]{"s3:GetObject"}).Resource(new String[]{"arn:aws:s3:::" + string + "/*"}).build();
        return BucketPolicyConfigDto.builder().Version("2012-10-17").Statement(CollUtil.toList((Object[])new BucketPolicyConfigDto.Statement[]{statement})).build();
    }

    @Generated
    public RustFSController() {
    }
}

