/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.statistics.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_app_data")
@TableName("t_app_data")
@Tag(name = "应用统计数据表")
public class AppData extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    private String vi;
    private String imei;
    private String userid;
    private String appversion;
    private String devicetoken;
    private String screenwidth;
    private String operator;
    private String deviceid;
    private String devicemodel;
    private String macaddr;
    private String connectiontype;
    private String bip;
    private String lasttime;
    private String appname;
    private String systemtype;
    private String devicename;
    private String upagename;
    private String systemversion;
    private String screenheight;
    private String bstag;
    private String channel;
    private String bid;
    private String mpagename;
    private String appinstalist;
    private String event;
}
