/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.statistics.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_track_event")
@TableName("t_track_event")
@Tag(name = "自定义事件表")
public class TrackEvent extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @Transient
    @TableField(exist = false)
    private String tag;

    private String ct;
    private String at;
    private String kl;
    private String vl;
    private String lt;
    private String sid;
    private String bid;
    private String ds;
    private String cl;
    private String tt;
    private String su;
    private String vi;
    private String ck;
    private String ln;
    private String ja;
    private String si;
    private String stag;
    private String ua;
    private String nu;
}
