/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.statistics.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.statistics.entity.AppData;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface AppDataService extends HiverBaseService<AppData, Long> {
    /**
     * 多条件分页获取
     */
    Page<AppData> findByCondition(AppData appData, SearchVo searchVo, Pageable pageable);
}
