/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.statistics.utils;

import lombok.extern.slf4j.Slf4j;

import java.net.URLDecoder;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
public class DecodeUtil {
    /**
     * URL解码
     *
     * @param x
     * @return
     */
    public static String decode(String x) {
        try {
            return URLDecoder.decode(x, "utf-8");
        } catch (Exception e) {
            log.error("URL解码失败", e);
        }
        return null;
    }

    /**
     * URL解码
     *
     * @param x
     * @param cl
     * @return
     */
    public static String decode(String x, String cl) {
        try {
            return URLDecoder.decode(x, cl);
        } catch (Exception e) {
            log.error("URL解码失败", e);
        }
        return null;
    }
}
