/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.statistics.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import eu.bitwalker.useragentutils.UserAgent;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.utils.DateUtil;
import plus.hiver.common.utils.IpInfoUtil;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.statistics.entity.AppData;
import plus.hiver.module.statistics.entity.Statistics;
import plus.hiver.module.statistics.entity.TrackEvent;
import plus.hiver.module.statistics.httpmodel.StatisticsParms;
import plus.hiver.module.statistics.service.AppDataService;
import plus.hiver.module.statistics.service.StatisticsService;
import plus.hiver.module.statistics.service.TrackEventService;
import plus.hiver.module.statistics.utils.DecodeUtil;
import plus.hiver.module.statistics.utils.ImageUtil;

@RestController
@Tag(name="\u7edf\u8ba1\u6570\u636e\u63a5\u53e3")
public class StatisticsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsController.class);
    @Resource
    private StatisticsService statisticsService;
    @Resource
    private TrackEventService trackEventService;
    @Resource
    private AppDataService appDataService;

    @PostMapping(value={"/hiver/track/hm.gif"})
    @Operation(summary="\u5e94\u7528\u4e8b\u4ef6\u7edf\u8ba1")
    public void track(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        try {
            Object object;
            Object object2;
            httpServletRequest.setCharacterEncoding("UTF-8");
            httpServletResponse.setHeader("Access-Control-Allow-Origin", "*");
            httpServletResponse.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
            httpServletResponse.setHeader("Access-Control-Max-Age", "3600");
            httpServletResponse.setHeader("Access-Control-Allow-Headers", "x-requested-with");
            httpServletResponse.setContentType("image/jpeg");
            if (StrUtil.isNotBlank((CharSequence)string)) {
                string = string.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
                string = URLDecoder.decode(string, StandardCharsets.UTF_8);
                string = URLDecoder.decode(string, StandardCharsets.UTF_8);
                object2 = Base64.decodeBase64((byte[])string.getBytes(StandardCharsets.UTF_8));
                object = new String((byte[])object2, StandardCharsets.UTF_8);
                List list = JSON.parseArray((String)object, AppData.class);
                for (AppData appData : list) {
                    this.appDataService.save(appData);
                }
            }
            object2 = httpServletResponse.getOutputStream();
            object = ImageUtil.generateImageIo();
            ImageIO.write((RenderedImage)object, "gif", (OutputStream)object2);
            object2.close();
        }
        catch (IOException iOException) {
            log.error("\u7edf\u8ba1\u6570\u636e\u5f02\u5e38", (Throwable)iOException);
        }
    }

    @GetMapping(value={"/hiver/hm.gif"})
    @Operation(summary="PV/UV\u6570\u636e\u7edf\u8ba1")
    public void hm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, StatisticsParms statisticsParms, TrackEvent trackEvent) {
        try {
            Object object;
            String string;
            httpServletRequest.setCharacterEncoding("UTF-8");
            httpServletResponse.setHeader("Access-Control-Allow-Origin", "*");
            httpServletResponse.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
            httpServletResponse.setHeader("Access-Control-Max-Age", "3600");
            httpServletResponse.setHeader("Access-Control-Allow-Headers", "x-requested-with");
            httpServletResponse.setContentType("image/jpeg");
            if (null != statisticsParms || null != trackEvent) {
                String string2;
                String string3;
                Object object2;
                Object object3;
                string = IpInfoUtil.getIpAddr((HttpServletRequest)httpServletRequest);
                statisticsParms.setTt(DecodeUtil.decode(statisticsParms.getTt()));
                statisticsParms.setSu(DecodeUtil.decode(DecodeUtil.decode(statisticsParms.getSu())));
                statisticsParms.setNu(DecodeUtil.decode(DecodeUtil.decode(statisticsParms.getNu())));
                object = new Statistics();
                ((Statistics)((Object)object)).setAr(statisticsParms.getAr());
                ((Statistics)((Object)object)).setAt(DateUtil.getDateMs());
                ((Statistics)((Object)object)).setIp(string);
                ((Statistics)((Object)object)).setVi(statisticsParms.getVi());
                ((Statistics)((Object)object)).setSu(statisticsParms.getSu());
                ((Statistics)((Object)object)).setSi(statisticsParms.getSi());
                ((Statistics)((Object)object)).setSb(statisticsParms.getSb());
                ((Statistics)((Object)object)).setRnd(statisticsParms.getRnd());
                ((Statistics)((Object)object)).setLn(statisticsParms.getLn());
                ((Statistics)((Object)object)).setJa(statisticsParms.getJa());
                ((Statistics)((Object)object)).setFl(statisticsParms.getFl());
                ((Statistics)((Object)object)).setDs(statisticsParms.getDs());
                ((Statistics)((Object)object)).setCl(statisticsParms.getCl());
                ((Statistics)((Object)object)).setCk(statisticsParms.getCk());
                ((Statistics)((Object)object)).setStag(statisticsParms.getStag());
                ((Statistics)((Object)object)).setTt(statisticsParms.getTt());
                ((Statistics)((Object)object)).setNu(statisticsParms.getNu());
                ((Statistics)((Object)object)).setLt(statisticsParms.getLt());
                ((Statistics)((Object)object)).setBid(statisticsParms.getBid());
                ((Statistics)((Object)object)).setSid(statisticsParms.getSid());
                ((Statistics)((Object)object)).setUa(statisticsParms.getUa());
                if (StrUtil.isNotBlank((CharSequence)((Statistics)((Object)object)).getIp()) && ((Matcher)(object3 = ((Pattern)(object2 = Pattern.compile(string3 = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}"))).matcher(((Statistics)((Object)object)).getIp()))).find()) {
                    string2 = "";
                    String string4 = "";
                    try {
                        string2 = "";
                        string4 = "";
                        if (StrUtil.isNotBlank((CharSequence)string2)) {
                            ((Statistics)((Object)object)).setAr(string2);
                        }
                        if (StrUtil.isNotBlank((CharSequence)string4)) {
                            ((Statistics)((Object)object)).setNetopt(string4);
                        }
                    }
                    catch (Exception exception) {
                        log.error("\u7edf\u8ba1\u6570\u636e\u5f02\u5e38", (Throwable)exception);
                    }
                }
                if (!StrUtil.isBlank((CharSequence)((Statistics)((Object)object)).getUa())) {
                    string3 = UserAgent.parseUserAgentString((String)((Statistics)((Object)object)).getUa());
                    object2 = string3.getBrowser();
                    object3 = string3.getOperatingSystem();
                    ((Statistics)((Object)object)).setBrowser(object2.getName());
                    ((Statistics)((Object)object)).setOs(object3.getName());
                    ((Statistics)((Object)object)).setDevicetype(object3.getDeviceType().getName());
                }
                if (StrUtil.isNotBlank((CharSequence)trackEvent.getTag()) && trackEvent.getTag().equals("_trackEvent")) {
                    string3 = trackEvent.getCt();
                    string3 = DecodeUtil.decode(string3);
                    object2 = trackEvent.getAt();
                    object2 = DecodeUtil.decode((String)object2);
                    object3 = trackEvent.getKl();
                    object3 = DecodeUtil.decode((String)object3);
                    string2 = trackEvent.getVl();
                    string2 = DecodeUtil.decode(string2);
                    trackEvent.setCt(string3);
                    trackEvent.setAt((String)object2);
                    trackEvent.setKl((String)object3);
                    trackEvent.setVl(string2);
                    this.trackEventService.save(trackEvent);
                } else {
                    this.statisticsService.save((HiverBaseEntity)object);
                }
            }
            string = httpServletResponse.getOutputStream();
            object = ImageUtil.generateImageIo();
            ImageIO.write((RenderedImage)object, "gif", (OutputStream)((Object)string));
            string.close();
        }
        catch (Exception exception) {
            log.error("\u7edf\u8ba1\u6570\u636e\u5f02\u5e38", (Throwable)exception);
        }
    }

    @GetMapping(value={"/hiver/statistics/getByCondition"})
    @Operation(summary="\u83b7\u5f97PV/UV\u6570\u636e\u7edf\u8ba1")
    public Result<Page<Statistics>> getStatisticsByCondition(Statistics statistics, SearchVo searchVo, PageVo pageVo) {
        Page<Statistics> page = this.statisticsService.findByCondition(statistics, searchVo, PageUtil.initPage((PageVo)pageVo));
        return new ResultUtil().setData(page);
    }

    @PostMapping(value={"/hiver/statistics/delByIds"})
    @Operation(summary="\u901a\u8fc7id\u5220\u9664")
    public Result delAllStatisticsByIds(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            this.statisticsService.delete(l);
        }
        return ResultUtil.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/hiver/track/getByCondition"})
    @Operation(summary="\u83b7\u5f97\u7f51\u9875\u4e8b\u4ef6\u6570\u636e")
    public Result<Page<TrackEvent>> getByCondition(TrackEvent trackEvent, SearchVo searchVo, PageVo pageVo) {
        Page<TrackEvent> page = this.trackEventService.findByCondition(trackEvent, searchVo, PageUtil.initPage((PageVo)pageVo));
        return new ResultUtil().setData(page);
    }

    @PostMapping(value={"/hiver/track/delByIds"})
    @Operation(summary="\u901a\u8fc7id\u5220\u9664")
    public Result delAllTrackByIds(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            this.trackEventService.delete(l);
        }
        return ResultUtil.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/hiver/app/getByCondition"})
    @Operation(summary="\u83b7\u5f97\u5e94\u7528\u4e8b\u4ef6\u6570\u636e")
    public Result<Page<AppData>> getByCondition(AppData appData, SearchVo searchVo, PageVo pageVo) {
        Page<AppData> page = this.appDataService.findByCondition(appData, searchVo, PageUtil.initPage((PageVo)pageVo));
        return new ResultUtil().setData(page);
    }

    @PostMapping(value={"/hiver/app/delByIds"})
    @Operation(summary="\u901a\u8fc7id\u5220\u9664")
    public Result delAllByIds(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            this.appDataService.delete(l);
        }
        return ResultUtil.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Generated
    public StatisticsController(StatisticsService statisticsService, TrackEventService trackEventService, AppDataService appDataService) {
        this.statisticsService = statisticsService;
        this.trackEventService = trackEventService;
        this.appDataService = appDataService;
    }
}

