/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.statistics.serviceimpl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.statistics.dao.TrackEventDao;
import plus.hiver.module.statistics.entity.TrackEvent;
import plus.hiver.module.statistics.service.TrackEventService;

@Service
@Transactional
public class TrackEventServiceImpl
extends HiverBaseServiceImpl<TrackEvent, Long, TrackEventDao>
implements TrackEventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrackEventServiceImpl.class);

    protected TrackEventServiceImpl(TrackEventDao trackEventDao) {
        super((HiverBaseDao)trackEventDao);
    }

    @Override
    public Page<TrackEvent> findByCondition(final TrackEvent trackEvent, final SearchVo searchVo, Pageable pageable) {
        return ((TrackEventDao)this.dao).findAll((Specification)new Specification<TrackEvent>(){

            @Nullable
            public Predicate toPredicate(Root<TrackEvent> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                DateTime dateTime;
                Path path = root.get("ct");
                Path path2 = root.get("kl");
                Path path3 = root.get("vl");
                Path path4 = root.get("tt");
                Path path5 = root.get("createTime");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)trackEvent.getCt())) {
                    arrayList.add(criteriaBuilder.like((Expression)path, "%" + trackEvent.getCt() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)trackEvent.getKl())) {
                    arrayList.add(criteriaBuilder.like((Expression)path2, "%" + trackEvent.getKl() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)trackEvent.getVl())) {
                    arrayList.add(criteriaBuilder.like((Expression)path3, "%" + trackEvent.getVl() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)trackEvent.getTt())) {
                    arrayList.add(criteriaBuilder.like((Expression)path4, "%" + trackEvent.getTt() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
                    dateTime = DateUtil.parse((CharSequence)searchVo.getStartDate());
                    DateTime dateTime2 = DateUtil.parse((CharSequence)searchVo.getEndDate());
                    arrayList.add(criteriaBuilder.between((Expression)path5, (Comparable)dateTime, (Comparable)DateUtil.endOfDay((Date)dateTime2)));
                }
                dateTime = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray((T[])dateTime));
                return null;
            }
        }, pageable);
    }
}

