/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.statistics.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_statistics_data")
@TableName("t_statistics_data")
@Tag(name = "PV/UV统计数据表")
public class Statistics extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    private String ar;
    private String at;
    private String ip;
    private String vi;
    private String su;
    private String si;
    private String sb;
    private String rnd;
    private String ln;
    private String ja;
    private String fl;
    private String ds;
    private String cl;
    private String ck;
    private String stag;
    private String tt;
    private String nu;
    private String lt;
    private String bid;
    private String sid;
    private String ua;
    private String netopt;
    private String browser;
    private String os;
    private String devicetype;
}
