/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.statistics.serviceimpl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.statistics.dao.AppDataDao;
import plus.hiver.module.statistics.entity.AppData;
import plus.hiver.module.statistics.service.AppDataService;

@Service
@Transactional
public class AppDataServiceImpl
extends HiverBaseServiceImpl<AppData, Long, AppDataDao>
implements AppDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppDataServiceImpl.class);

    protected AppDataServiceImpl(AppDataDao appDataDao) {
        super((HiverBaseDao)appDataDao);
    }

    @Override
    public Page<AppData> findByCondition(final AppData appData, final SearchVo searchVo, Pageable pageable) {
        return ((AppDataDao)this.dao).findAll((Specification)new Specification<AppData>(){

            @Nullable
            public Predicate toPredicate(Root<AppData> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                DateTime dateTime;
                Path path = root.get("appversion");
                Path path2 = root.get("imei");
                Path path3 = root.get("devicetoken");
                Path path4 = root.get("macaddr");
                Path path5 = root.get("createTime");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)appData.getAppversion())) {
                    arrayList.add(criteriaBuilder.like((Expression)path, "%" + appData.getAppversion() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)appData.getImei())) {
                    arrayList.add(criteriaBuilder.like((Expression)path2, "%" + appData.getImei() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)appData.getDevicetoken())) {
                    arrayList.add(criteriaBuilder.like((Expression)path3, "%" + appData.getImei() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)appData.getMacaddr())) {
                    arrayList.add(criteriaBuilder.like((Expression)path4, "%" + appData.getImei() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
                    dateTime = DateUtil.parse((CharSequence)searchVo.getStartDate());
                    DateTime dateTime2 = DateUtil.parse((CharSequence)searchVo.getEndDate());
                    arrayList.add(criteriaBuilder.between((Expression)path5, (Comparable)dateTime, (Comparable)DateUtil.endOfDay((Date)dateTime2)));
                }
                dateTime = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray((T[])dateTime));
                return null;
            }
        }, pageable);
    }
}

