/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.statistics.serviceimpl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.statistics.dao.StatisticsDao;
import plus.hiver.module.statistics.entity.Statistics;
import plus.hiver.module.statistics.service.StatisticsService;

@Service
@Transactional
public class StatisticsServiceImpl
extends HiverBaseServiceImpl<Statistics, Long, StatisticsDao>
implements StatisticsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsServiceImpl.class);

    protected StatisticsServiceImpl(StatisticsDao statisticsDao) {
        super((HiverBaseDao)statisticsDao);
    }

    @Override
    public Page<Statistics> findByCondition(final Statistics statistics, final SearchVo searchVo, Pageable pageable) {
        return ((StatisticsDao)this.dao).findAll((Specification)new Specification<Statistics>(){

            @Nullable
            public Predicate toPredicate(Root<Statistics> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                DateTime dateTime;
                Path path = root.get("ar");
                Path path2 = root.get("ip");
                Path path3 = root.get("tt");
                Path path4 = root.get("nu");
                Path path5 = root.get("createTime");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)statistics.getAr())) {
                    arrayList.add(criteriaBuilder.like((Expression)path, "%" + statistics.getAr() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)statistics.getIp())) {
                    arrayList.add(criteriaBuilder.like((Expression)path2, "%" + statistics.getIp() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)statistics.getTt())) {
                    arrayList.add(criteriaBuilder.like((Expression)path3, "%" + statistics.getTt() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)statistics.getNu())) {
                    arrayList.add(criteriaBuilder.like((Expression)path4, "%" + statistics.getNu() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
                    dateTime = DateUtil.parse((CharSequence)searchVo.getStartDate());
                    DateTime dateTime2 = DateUtil.parse((CharSequence)searchVo.getEndDate());
                    arrayList.add(criteriaBuilder.between((Expression)path5, (Comparable)dateTime, (Comparable)DateUtil.endOfDay((Date)dateTime2)));
                }
                dateTime = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray((T[])dateTime));
                return null;
            }
        }, pageable);
    }
}

