/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;

/**
 * 站内消息实例
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Setter
@Getter
@Accessors(chain = true)
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "t_message")
@TableName("t_message")
@Tag(name = "消息")
public class Message extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @Schema(description = "标题")
    private String title;

    @Schema(description = "内容")
    private String content;

    @Schema(description = "消息类型")
    private String type;

    @Schema(description = "新创建账号也推送")
    private Boolean createSend;

    @Schema(description = "是否为模版消息")
    private Boolean isTemplate;

    @Transient
    @TableField(exist = false)
    @Schema(description = "纯文本内容")
    private String contentText;

    @Transient
    @TableField(exist = false)
    @Schema(description = "发送范围")
    private Integer range;

    @Transient
    @TableField(exist = false)
    @Schema(description = "发送指定用户id")
    private Long[] userIds;
}
