/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.MessageConstant;

/**
 * 发送消息实例
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Setter
@Getter
@Accessors(chain = true)
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "t_message_send")
@TableName("t_message_send")
@Tag(name = "消息发送详情")
public class MessageSend extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @Schema(description = "关联消息id")
    private Long messageId;

    @Schema(description = "关联用户id")
    private Long userId;

    @Schema(description = "消息参数")
    private String params;

    @Schema(description = "状态 0默认未读 1已读 2回收站")
    private Integer status = MessageConstant.MESSAGE_STATUS_UNREAD;

    @Transient
    @TableField(exist = false)
    @Schema(description = "发送登录名")
    private String username;

    @Transient
    @TableField(exist = false)
    @Schema(description = "发送用户名")
    private String nickname;

    @Transient
    @TableField(exist = false)
    @Schema(description = "消息标题")
    private String title;

    @Transient
    @TableField(exist = false)
    @Schema(description = "消息内容")
    private String content;

    @Transient
    @TableField(exist = false)
    @Schema(description = "消息类型")
    private String type;
}
