/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.annotation.SystemLog;
import plus.hiver.common.api.Result;
import plus.hiver.common.config.properties.HiverTokenProperties;
import plus.hiver.common.entity.User;
import plus.hiver.common.enums.LogType;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SecurityUtil;

@RestController
@Tag(name="\u7528\u6237\u8ba4\u8bc1\u76f8\u5173\u63a5\u53e3")
@PermissionTag(permission="auth:*")
@RequestMapping(value={"/hiver/auth"})
@CacheConfig(cacheNames={"user"})
@Transactional
public class AuthController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);
    public static final String USER = "username::";
    public static final String LOGIN_FAIL_FLAG = "LOGIN_FAIL_FLAG:";
    public static final String LOGIN_TIME_LIMIT = "LOGIN_TIME_LIMIT:";
    public static final Integer LOGIN_FAIL_TIP_TIME = 3;
    @Resource
    private HiverTokenProperties tokenProperties;
    @Resource
    private SecurityUtil securityUtil;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @PostMapping(value={"/login"})
    @SystemLog(description="\u8d26\u53f7\u767b\u5f55", type=LogType.LOGIN)
    @Operation(summary="\u8d26\u53f7/\u624b\u673a/\u90ae\u7bb1\u767b\u5f55")
    public Result login(@RequestParam String string, @RequestParam String string2, @RequestParam(required=false) Boolean bl) {
        String string3 = LOGIN_FAIL_FLAG + string;
        String string4 = LOGIN_TIME_LIMIT + string;
        String string5 = this.redisTemplateHelper.get(string3);
        Long l = this.redisTemplateHelper.getExpire(string3, TimeUnit.MINUTES);
        if (StrUtil.isNotBlank((CharSequence)string5)) {
            return ResultUtil.error((String)("\u767b\u5f55\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u8bf7" + l + "\u5206\u949f\u540e\u518d\u8bd5"));
        }
        User user = this.securityUtil.checkUserPassword(string, string2);
        if (user == null) {
            int n;
            String string6 = this.redisTemplateHelper.get(string4);
            if (StrUtil.isBlank((CharSequence)string6)) {
                string6 = "0";
            }
            Integer n2 = Integer.parseInt(string6) + 1;
            this.redisTemplateHelper.set(string4, n2.toString(), (long)this.tokenProperties.getLoginAfterTime().intValue(), TimeUnit.MINUTES);
            if (n2 >= this.tokenProperties.getLoginTimeLimit()) {
                this.redisTemplateHelper.set(string3, "FAIL", (long)this.tokenProperties.getLoginAfterTime().intValue(), TimeUnit.MINUTES);
            }
            if ((n = this.tokenProperties.getLoginTimeLimit() - n2) > 0 && n <= LOGIN_FAIL_TIP_TIME) {
                return ResultUtil.error((String)("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + n + "\u6b21\u5c1d\u8bd5\u673a\u4f1a"));
            }
            if (n <= 0) {
                return ResultUtil.error((String)("\u767b\u5f55\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u8bf7" + this.tokenProperties.getLoginAfterTime() + "\u5206\u949f\u540e\u518d\u8bd5"));
            }
            return ResultUtil.error((String)"\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        String string7 = this.securityUtil.getToken(user, bl);
        return ResultUtil.data((Object)string7);
    }

    @PostMapping(value={"/logout"})
    @Operation(summary="\u7528\u6237\u6ce8\u9500")
    public Result logout() {
        User user = this.securityUtil.getCurrUser();
        this.redisTemplateHelper.delete(USER + user.getUsername());
        String string = this.redisTemplateHelper.get("HIVER_USER_TOKEN:" + user.getUsername());
        this.redisTemplateHelper.delete("ONLINE_USER:" + user.getUsername() + ":" + string);
        this.redisTemplateHelper.delete("HIVER_TOKEN_PRE:" + string);
        this.redisTemplateHelper.delete("HIVER_USER_TOKEN:" + user.getUsername());
        return ResultUtil.success((String)"\u6ce8\u9500\u6210\u529f");
    }

    @Generated
    public AuthController(HiverTokenProperties hiverTokenProperties, SecurityUtil securityUtil, RedisTemplateHelper redisTemplateHelper) {
        this.tokenProperties = hiverTokenProperties;
        this.securityUtil = securityUtil;
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

