/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.module.system.entity.Dict;
import plus.hiver.module.system.service.DictDataService;
import plus.hiver.module.system.service.DictService;

@RestController
@Tag(name="\u5b57\u5178\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="dict:*")
@RequestMapping(value={"/hiver/dict"})
@Transactional
public class DictController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictController.class);
    @Resource
    private DictService dictService;
    @Resource
    private DictDataService dictDataService;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @GetMapping(value={"/getAll"})
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u6570\u636e")
    public Result<List<Dict>> getAll() {
        List<Dict> list = this.dictService.findAllOrderBySortOrder();
        return new ResultUtil().setData(list);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u6dfb\u52a0")
    public Result add(Dict dict) {
        if (this.dictService.findByType(dict.getType()) != null) {
            return ResultUtil.error((String)"\u5b57\u5178\u7c7b\u578bType\u5df2\u5b58\u5728");
        }
        this.dictService.save((Object)dict);
        return ResultUtil.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u7f16\u8f91")
    public Result edit(Dict dict) {
        Dict dict2 = (Dict)((Object)this.dictService.get(dict.getId()));
        if (!dict2.getType().equals(dict.getType()) && this.dictService.findByType(dict.getType()) != null) {
            return ResultUtil.error((String)"\u5b57\u5178\u7c7b\u578bType\u5df2\u5b58\u5728");
        }
        this.dictService.update((Object)dict);
        this.redisTemplateHelper.delete("dictData::" + dict.getType());
        return ResultUtil.success((String)"\u7f16\u8f91\u6210\u529f");
    }

    @PostMapping(value={"/delByIds"})
    @Operation(summary="\u901a\u8fc7id\u5220\u9664")
    public Result delAllByIds(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            Dict dict = (Dict)((Object)this.dictService.get(l));
            this.dictService.delete(l);
            this.dictDataService.deleteByDictId(l);
            this.redisTemplateHelper.delete("dictData::" + dict.getType());
        }
        return ResultUtil.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    @Operation(summary="\u641c\u7d22\u5b57\u5178")
    public Result<List<Dict>> searchPermissionList(@RequestParam String string) {
        List<Dict> list = this.dictService.findByTitleOrTypeLike(string);
        return new ResultUtil().setData(list);
    }

    @Generated
    public DictController(DictService dictService, DictDataService dictDataService, RedisTemplateHelper redisTemplateHelper) {
        this.dictService = dictService;
        this.dictDataService = dictDataService;
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

