/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.module.system.entity.Dict;
import plus.hiver.module.system.entity.DictData;
import plus.hiver.module.system.service.DictDataService;
import plus.hiver.module.system.service.DictService;

@RestController
@Tag(name="\u5b57\u5178\u6570\u636e\u63a5\u53e3")
@PermissionTag(permission="dictData:*")
@RequestMapping(value={"/hiver/dictData"})
@CacheConfig(cacheNames={"dictData"})
@Transactional
public class DictDataController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictDataController.class);
    @Resource
    private DictService dictService;
    @Resource
    private DictDataService dictDataService;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @GetMapping(value={"/getByCondition"})
    @Operation(summary="\u591a\u6761\u4ef6\u5206\u9875\u83b7\u53d6\u7528\u6237\u5217\u8868")
    public Result<Page<DictData>> getByCondition(DictData dictData, PageVo pageVo) {
        Page<DictData> page = this.dictDataService.findByCondition(dictData, PageUtil.initPage((PageVo)pageVo));
        return new ResultUtil().setData(page);
    }

    @GetMapping(value={"/getByType/{type}"})
    @Operation(summary="\u901a\u8fc7\u7c7b\u578b\u83b7\u53d6")
    @Cacheable(key="#type")
    public Result getByType(@PathVariable String string) {
        Dict dict = this.dictService.findByType(string);
        if (dict == null) {
            return ResultUtil.error((String)("\u5b57\u5178\u7c7b\u578b " + string + " \u4e0d\u5b58\u5728"));
        }
        List<DictData> list = this.dictDataService.findByDictId(dict.getId());
        return ResultUtil.data(list);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u6dfb\u52a0")
    public Result add(DictData dictData) {
        Dict dict = (Dict)((Object)this.dictService.get(dictData.getDictId()));
        this.dictDataService.save((Object)dictData);
        this.redisTemplateHelper.delete("dictData::" + dict.getType());
        return ResultUtil.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u7f16\u8f91")
    public Result edit(DictData dictData) {
        this.dictDataService.update((Object)dictData);
        Dict dict = (Dict)((Object)this.dictService.get(dictData.getDictId()));
        this.redisTemplateHelper.delete("dictData::" + dict.getType());
        return ResultUtil.success((String)"\u7f16\u8f91\u6210\u529f");
    }

    @PostMapping(value={"/delByIds"})
    @Operation(summary="\u6279\u91cf\u901a\u8fc7id\u5220\u9664")
    public Result delByIds(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            DictData dictData = (DictData)((Object)this.dictDataService.get(l));
            Dict dict = (Dict)((Object)this.dictService.get(dictData.getDictId()));
            this.dictDataService.delete(l);
            this.redisTemplateHelper.delete("dictData::" + dict.getType());
        }
        return ResultUtil.success((String)"\u6279\u91cf\u901a\u8fc7id\u5220\u9664\u6570\u636e\u6210\u529f");
    }

    @Generated
    public DictDataController(DictService dictService, DictDataService dictDataService, RedisTemplateHelper redisTemplateHelper) {
        this.dictService = dictService;
        this.dictDataService = dictDataService;
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

