/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.http.HtmlUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.constant.MessageConstant;
import plus.hiver.common.service.UserService;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.system.entity.Message;
import plus.hiver.module.system.entity.MessageSend;
import plus.hiver.module.system.service.MessageSendService;
import plus.hiver.module.system.service.MessageService;

@RestController
@Tag(name="\u6d88\u606f\u5185\u5bb9\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="message:*")
@RequestMapping(value={"/hiver/message"})
@Transactional
public class MessageController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageController.class);
    @Resource
    private MessageService messageService;
    @Resource
    private MessageSendService sendService;
    @Resource
    private UserService userService;
    @Resource
    private SimpMessagingTemplate messagingTemplate;

    @GetMapping(value={"/getByCondition"})
    @Operation(summary="\u591a\u6761\u4ef6\u5206\u9875\u83b7\u53d6")
    public Result<Page<Message>> getByCondition(Message message2, SearchVo searchVo, PageVo pageVo) {
        Page<Message> page = this.messageService.findByCondition(message2, searchVo, PageUtil.initPage((PageVo)pageVo));
        page.forEach(message -> message.setContentText(HtmlUtil.cleanHtmlTag((String)message.getContent())));
        return new ResultUtil().setData(page);
    }

    @GetMapping(value={"/get/{id}"})
    @Operation(summary="\u901a\u8fc7id\u83b7\u53d6")
    public Result<Message> get(@PathVariable Long l) {
        Message message = (Message)((Object)this.messageService.get(l));
        message.setContentText(HtmlUtil.filter((String)message.getContent()));
        return new ResultUtil().setData((Object)message);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u6dfb\u52a0\u6d88\u606f")
    public Result addMessage(Message message) {
        Message message2 = (Message)((Object)this.messageService.save((Object)message));
        ArrayList<MessageSend> arrayList = new ArrayList<MessageSend>();
        if (MessageConstant.MESSAGE_RANGE_ALL.equals(message.getRange())) {
            List list = this.userService.getAll();
            list.forEach(user -> {
                MessageSend messageSend = new MessageSend().setMessageId(message2.getId()).setUserId(user.getId());
                arrayList.add(messageSend);
            });
            this.sendService.saveOrUpdateAll(arrayList);
            this.messagingTemplate.convertAndSend((Object)"/topic/subscribe", (Object)"\u60a8\u6536\u5230\u4e86\u65b0\u7684\u7cfb\u7edf\u6d88\u606f");
        } else if (MessageConstant.MESSAGE_RANGE_USER.equals(message.getRange())) {
            for (Long l : message.getUserIds()) {
                MessageSend messageSend = new MessageSend().setMessageId(message2.getId()).setUserId(l);
                arrayList.add(messageSend);
            }
            this.sendService.saveOrUpdateAll(arrayList);
            for (Long l : message.getUserIds()) {
                this.messagingTemplate.convertAndSendToUser(l.toString(), "/queue/subscribe", (Object)"\u60a8\u6536\u5230\u4e86\u65b0\u7684\u6d88\u606f");
            }
        }
        return ResultUtil.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u7f16\u8f91\u6d88\u606f")
    public Result editMessage(Message message) {
        Message message2 = (Message)((Object)this.messageService.update((Object)message));
        return ResultUtil.success((String)"\u7f16\u8f91\u6210\u529f");
    }

    @PostMapping(value={"/delByIds"})
    @Operation(summary="\u5220\u9664\u6d88\u606f")
    public Result delMessage(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            this.messageService.delete(l);
            this.sendService.deleteByMessageId(l);
        }
        return ResultUtil.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Generated
    public MessageController(MessageService messageService, MessageSendService messageSendService, UserService userService, SimpMessagingTemplate simpMessagingTemplate) {
        this.messageService = messageService;
        this.sendService = messageSendService;
        this.userService = userService;
        this.messagingTemplate = simpMessagingTemplate;
    }
}

